/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.services.DataTypeManagerService;
import ghidra.features.base.quickfix.QuickFix;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Program;
import java.util.Map;

public abstract class CompositeFieldQuickFix
extends QuickFix {
    protected Composite composite;
    private int ordinal;

    public CompositeFieldQuickFix(Program program, Composite composite, int ordinal, String original, String newName) {
        super(program, original, newName);
        this.composite = composite;
        this.ordinal = ordinal;
    }

    @Override
    public Address getAddress() {
        return null;
    }

    @Override
    public String getPath() {
        return this.composite.getPathName();
    }

    protected DataTypeComponent findComponent(String name) {
        DataTypeComponent component = this.getComponentByOrdinal();
        if (component != null && name.equals(component.getFieldName())) {
            return component;
        }
        DataTypeComponent[] components = this.composite.getDefinedComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!name.equals(components[i].getFieldName())) continue;
            this.ordinal = i;
            return components[i];
        }
        return null;
    }

    protected DataTypeComponent getComponentByOrdinal() {
        if (this.composite.isDeleted()) {
            return null;
        }
        if (this.ordinal >= this.composite.getNumComponents()) {
            return null;
        }
        return this.composite.getComponent(this.ordinal);
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        return Map.of("DataType", this.composite.getPathName());
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        DataTypeManagerService dtmService = (DataTypeManagerService)services.getService(DataTypeManagerService.class);
        if (dtmService == null) {
            return false;
        }
        dtmService.setDataTypeSelected((DataType)this.composite);
        if (!fromSelectionChange) {
            dtmService.edit(this.composite, this.getFieldName());
        }
        return true;
    }

    protected abstract String getFieldName();

    protected void editComposite(DataTypeManagerService dtmService) {
        dtmService.edit((DataType)this.composite);
    }
}

