/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class RelocBySectDWithSkip
extends Relocation {
    private int skipCount;
    private int relocCount;

    RelocBySectDWithSkip(BinaryReader reader) throws IOException {
        int value = reader.readNextShort() & 0xFFFF;
        this.opcode = (value & 0xC000) >> 14 & 3;
        this.skipCount = (value & 0x3FC0) >> 6;
        this.relocCount = value & 0x3F;
    }

    @Override
    public boolean isMatch() {
        return this.opcode == 0;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getRelocCount() {
        return this.relocCount;
    }

    @Override
    public void apply(ImportStateCache importState, RelocationState relocState, ContainerHeader header, Program program, MessageLog log, TaskMonitor monitor) {
        relocState.incrementRelocationAddress(this.skipCount * 4);
        for (int i = 0; i < this.relocCount; ++i) {
            relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionD().getOffset(), log);
            relocState.incrementRelocationAddress(4);
        }
    }
}

