/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecoderFactory;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisClass;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class LSDATypeTable
extends GccAnalysisClass {
    private RegionDescriptor region;
    private Address nextAddress;
    private List<Address> typeInfoAddrs = new ArrayList<Address>(2);

    public LSDATypeTable(TaskMonitor monitor, Program program, RegionDescriptor region) {
        super(monitor, program);
        this.region = region;
    }

    public void create(Address bottom, Address top) {
        if (bottom == null || top == null || this.monitor.isCancelled()) {
            return;
        }
        this.monitor.setMessage("Creating LSDA Type Table");
        int encoding = this.region.getLSDATable().getHeader().getTTypeEncoding();
        DwarfEHDecoder decoder = DwarfDecoderFactory.getDecoder(encoding);
        DataType encodedDt = decoder.getDataType(this.program);
        int stride = decoder.getDecodeSize(this.program);
        String comment = "Type Reference";
        top = this.align4(top);
        Address addr = bottom.subtract((long)(stride - 1));
        while (addr.compareTo((Object)top) >= 0) {
            DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, addr);
            try {
                Address typeRef = decoder.decodeAddress(ctx);
                this.typeInfoAddrs.add(typeRef);
                LSDATypeTable.createAndCommentData(this.program, addr, encodedDt, comment, CommentType.EOL);
                if (typeRef.getOffset() != 0L) {
                    this.program.getReferenceManager().addMemoryReference(addr, typeRef, RefType.DATA, SourceType.ANALYSIS, 0);
                }
            }
            catch (MemoryAccessException mae) {
                SetCommentCmd commentCmd = new SetCommentCmd(addr, CommentType.EOL, "Unable to resolve pointer");
                commentCmd.applyTo(this.program);
            }
            addr = addr.subtract((long)stride);
        }
        SetCommentCmd commentCmd = new SetCommentCmd(top, CommentType.PLATE, "(LSDA) Type Table");
        commentCmd.applyTo(this.program);
        this.nextAddress = bottom.add(1L);
    }

    private Address align4(Address addr) {
        int incr = 4 - ((int)addr.getOffset() & 3);
        if (incr == 4) {
            return addr;
        }
        LSDATypeTable.createAndCommentData(this.program, addr, (DataType)new ArrayDataType((DataType)new ByteDataType(), incr, 1), " -- alignment pad", CommentType.EOL);
        return addr.add((long)incr);
    }

    public Address getTypeInfoAddress(int index) {
        if (index <= 0 || index > this.typeInfoAddrs.size()) {
            return Address.NO_ADDRESS;
        }
        return this.typeInfoAddrs.get(index - 1);
    }

    public Address getNextAddress() {
        return this.nextAddress;
    }
}

