/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.registry;

import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.internal.UIActivator;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.osgi.framework.Bundle;

public class ConfirmationDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(ConfirmationDescriptor.class);
    public static final String ELEMENT_ID = "confirmation";
    private final String id;
    private final String title;
    private final String description;
    private final String message;
    private final String toggleMessage;
    private final String group;

    ConfirmationDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.title = config.getAttribute("title");
        this.description = config.getAttribute("description");
        this.message = config.getAttribute("message");
        String toggleMessageStr = config.getAttribute("toggleMessage");
        if ("default".equals(toggleMessageStr)) {
            ResourceBundle resourceBundle = RuntimeUtils.getBundleLocalization((Bundle)UIActivator.getDefault().getBundle(), (String)Locale.getDefault().getLanguage());
            try {
                toggleMessageStr = resourceBundle.getString("confirm.general.toggleMessage");
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            this.toggleMessage = toggleMessageStr;
        } else {
            this.toggleMessage = toggleMessageStr;
        }
        this.group = config.getAttribute("group");
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getToggleMessage() {
        return this.toggleMessage;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }
}

