/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.sisu.bean.BeanLifecycle;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.BeanScheduler;
import org.eclipse.sisu.bean.LifecycleBuilder;
import org.eclipse.sisu.bean.PropertyBinding;

public final class LifecycleManager
extends BeanScheduler
implements BeanManager {
    private final LifecycleBuilder builder = new LifecycleBuilder();
    private final Map<Class<?>, BeanLifecycle> lifecycles = new ConcurrentHashMap();
    private final Deque<Object> stoppableBeans = new ArrayDeque<Object>();

    @Override
    public boolean manage(Class<?> clazz) {
        return this.buildLifecycle(clazz);
    }

    @Override
    public PropertyBinding manage(BeanProperty<?> property) {
        return null;
    }

    @Override
    public boolean manage(Object bean2) {
        BeanLifecycle lifecycle = this.lifecycleFor(bean2);
        if (lifecycle.isStoppable()) {
            this.pushStoppable(bean2);
        }
        if (lifecycle.isStartable()) {
            this.schedule(bean2);
        }
        return true;
    }

    @Override
    public boolean unmanage(Object bean2) {
        if (this.removeStoppable(bean2)) {
            this.lifecycleFor(bean2).stop(bean2);
        }
        return true;
    }

    @Override
    public boolean unmanage() {
        Object bean2;
        while ((bean2 = this.popStoppable()) != null) {
            this.lifecycleFor(bean2).stop(bean2);
        }
        return true;
    }

    @Override
    protected void activate(Object bean2) {
        this.lifecycleFor(bean2).start(bean2);
    }

    private boolean buildLifecycle(Class<?> clazz) {
        BeanLifecycle lifecycle = this.lifecycles.get(clazz);
        if (lifecycle == null) {
            lifecycle = this.builder.build(clazz);
            this.lifecycles.put(clazz, lifecycle);
        }
        return lifecycle != BeanLifecycle.NO_OP;
    }

    private BeanLifecycle lifecycleFor(Object bean2) {
        if (bean2 != null) {
            Class<?> c = bean2.getClass();
            while (c != null && c != Object.class) {
                BeanLifecycle lifecycle = this.lifecycles.get(c);
                if (lifecycle != null) {
                    return lifecycle;
                }
                c = c.getSuperclass();
            }
        }
        return BeanLifecycle.NO_OP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushStoppable(Object bean2) {
        Deque<Object> deque = this.stoppableBeans;
        synchronized (deque) {
            this.stoppableBeans.addLast(bean2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeStoppable(Object bean2) {
        Deque<Object> deque = this.stoppableBeans;
        synchronized (deque) {
            return this.stoppableBeans.remove(bean2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object popStoppable() {
        Deque<Object> deque = this.stoppableBeans;
        synchronized (deque) {
            return this.stoppableBeans.pollLast();
        }
    }
}

