/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.List;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationGeneratedFilter
implements IFilter {
    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        for (String annotation : context.getClassAnnotations()) {
            if (!AnnotationGeneratedFilter.matches(annotation)) continue;
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
            return;
        }
        if (AnnotationGeneratedFilter.presentIn(methodNode.invisibleAnnotations) || AnnotationGeneratedFilter.presentIn(methodNode.visibleAnnotations)) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private static boolean matches(String annotation) {
        String name = annotation.substring(Math.max(annotation.lastIndexOf(47), annotation.lastIndexOf(36)) + 1);
        return name.contains("Generated");
    }

    private static boolean presentIn(List<AnnotationNode> annotations) {
        if (annotations != null) {
            for (AnnotationNode annotation : annotations) {
                if (!AnnotationGeneratedFilter.matches(annotation.desc)) continue;
                return true;
            }
        }
        return false;
    }
}

