﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lambda/Lambda_EXPORTS.h>

namespace Aws {
namespace Lambda {
namespace Model {
enum class EventSourceMappingSystemLogLevel { NOT_SET, DEBUG_, INFO, WARN };

namespace EventSourceMappingSystemLogLevelMapper {
AWS_LAMBDA_API EventSourceMappingSystemLogLevel GetEventSourceMappingSystemLogLevelForName(const Aws::String& name);

AWS_LAMBDA_API Aws::String GetNameForEventSourceMappingSystemLogLevel(EventSourceMappingSystemLogLevel value);
}  // namespace EventSourceMappingSystemLogLevelMapper
}  // namespace Model
}  // namespace Lambda
}  // namespace Aws
