/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionUtil_Compile;

import BoundedInts_Compile.uint8;
import StructuredEncryptionUtil_Compile.CanonCryptoItem;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyHaltException;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Function0;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthItem;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoItem;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.PathSegment;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructureSegment;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;

public class __default {
    public static DafnySet<? extends DafnySequence<? extends PathSegment>> CryptoListToSet(DafnySequence<? extends CryptoItem> xs) {
        return ((Function<DafnySequence, DafnySet>)_0_xs -> (DafnySet)((Function0)() -> {
            ArrayList<DafnySequence<? extends PathSegment>> _coll0 = new ArrayList<DafnySequence<? extends PathSegment>>();
            for (CryptoItem _compr_0_boxed0 : _0_xs.Elements()) {
                CryptoItem _compr_0 = _compr_0_boxed0;
                CryptoItem _1_k = _compr_0;
                if (!_0_xs.contains((Object)_1_k)) continue;
                _coll0.add(_1_k.dtor_key());
            }
            return new DafnySet(_coll0);
        }).apply()).apply(xs);
    }

    public static DafnySet<? extends DafnySequence<? extends PathSegment>> CanonCryptoListToSet(DafnySequence<? extends CanonCryptoItem> xs) {
        return ((Function<DafnySequence, DafnySet>)_0_xs -> (DafnySet)((Function0)() -> {
            ArrayList<DafnySequence<? extends PathSegment>> _coll0 = new ArrayList<DafnySequence<? extends PathSegment>>();
            for (CanonCryptoItem _compr_0_boxed0 : _0_xs.Elements()) {
                CanonCryptoItem _compr_0 = _compr_0_boxed0;
                CanonCryptoItem _1_k = _compr_0;
                if (!_0_xs.contains((Object)_1_k)) continue;
                _coll0.add(_1_k.dtor_origKey());
            }
            return new DafnySet(_coll0);
        }).apply()).apply(xs);
    }

    public static DafnySet<? extends DafnySequence<? extends PathSegment>> AuthListToSet(DafnySequence<? extends AuthItem> xs) {
        return ((Function<DafnySequence, DafnySet>)_0_xs -> (DafnySet)((Function0)() -> {
            ArrayList<DafnySequence<? extends PathSegment>> _coll0 = new ArrayList<DafnySequence<? extends PathSegment>>();
            for (AuthItem _compr_0_boxed0 : _0_xs.Elements()) {
                AuthItem _compr_0 = _compr_0_boxed0;
                AuthItem _1_k = _compr_0;
                if (!_0_xs.contains((Object)_1_k)) continue;
                _coll0.add(_1_k.dtor_key());
            }
            return new DafnySet(_coll0);
        }).apply()).apply(xs);
    }

    public static boolean CryptoListHasNoDuplicatesFromSet(DafnySequence<? extends CryptoItem> xs) {
        return (long)__default.CryptoListToSet(xs).cardinalityInt() == (long)xs.cardinalityInt();
    }

    public static boolean AuthListHasNoDuplicatesFromSet(DafnySequence<? extends AuthItem> xs) {
        return (long)__default.AuthListToSet(xs).cardinalityInt() == (long)xs.cardinalityInt();
    }

    public static boolean ValidString(DafnySequence<? extends Character> x) {
        return StandardLibrary_mUInt_Compile.__default.HasUint64Len((TypeDescriptor)TypeDescriptor.CHAR, x) && UTF8.__default.Encode(x).is_Success();
    }

    public static boolean ValidSuite(AlgorithmSuiteInfo alg) {
        return alg.dtor_id().is_DBE() && AlgorithmSuites_Compile.__default.DBEAlgorithmSuite_q((AlgorithmSuiteInfo)alg);
    }

    public static Error E(DafnySequence<? extends Character> s) {
        return Error.create_StructuredEncryptionException(s);
    }

    public static byte ConstantTimeCompare(DafnySequence<? extends Byte> a, DafnySequence<? extends Byte> b, long pos, byte acc) {
        while ((long)a.cardinalityInt() != pos) {
            byte _0_x = (byte)((Byte)a.select(Helpers.unsignedToInt((long)pos)) ^ (Byte)b.select(Helpers.unsignedToInt((long)pos)));
            DafnySequence<? extends Byte> _in0 = a;
            DafnySequence<? extends Byte> _in1 = b;
            long _in2 = pos + 1L;
            byte _in3 = (byte)(_0_x | acc);
            a = _in0;
            b = _in1;
            pos = _in2;
            acc = _in3;
        }
        return acc;
    }

    public static boolean ConstantTimeEquals(DafnySequence<? extends Byte> a, DafnySequence<? extends Byte> b) {
        return !(__default.ConstantTimeCompare(a, b, 0L, (byte)0) != 0);
    }

    public static boolean IsAuthAttr(CryptoAction x) {
        return !x.is_DO__NOTHING();
    }

    public static StructuredDataTerminal ValueToData(DafnySequence<? extends Byte> value, DafnySequence<? extends Byte> typeId) {
        return StructuredDataTerminal.create(value, typeId);
    }

    public static DafnySequence<? extends Byte> GetValue(StructuredDataTerminal data) {
        return data.dtor_value();
    }

    public static boolean ByteLess(byte x, byte y) {
        return Integer.compareUnsigned(x, y) < 0;
    }

    public static boolean CharLess(char x, char y) {
        return x < y;
    }

    public static DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> EcAsString(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> ec) {
        DafnyMap output = DafnyMap.empty();
        DafnySequence _0_keys = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)uint8._typeDescriptor(), (DafnySet)ec.keySet(), __default::ByteLess);
        DafnyMap _1_ret = DafnyMap.fromElements((Tuple2[])new Tuple2[0]);
        long _hi0 = _0_keys.cardinalityInt();
        long _2_i = 0L;
        while (Long.compareUnsigned(_2_i, _hi0) < 0) {
            Result _3_valueOrError0 = Result.Default((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _3_valueOrError0 = UTF8.__default.Decode((DafnySequence)((DafnySequence)_0_keys.select(Helpers.unsignedToInt((long)_2_i))));
            if (_3_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                throw new DafnyHaltException("dafny/StructuredEncryption/src/Util.dfy(304,17): " + String.valueOf(_3_valueOrError0));
            }
            DafnySequence _4_key = (DafnySequence)_3_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            Result _5_valueOrError1 = Result.Default((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _5_valueOrError1 = UTF8.__default.Decode((DafnySequence)((DafnySequence)ec.get((Object)((DafnySequence)_0_keys.select(Helpers.unsignedToInt((long)_2_i))))));
            if (_5_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                throw new DafnyHaltException("dafny/StructuredEncryption/src/Util.dfy(305,19): " + String.valueOf(_5_valueOrError1));
            }
            DafnySequence _6_value = (DafnySequence)_5_valueOrError1.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            _1_ret = DafnyMap.update((DafnyMap)_1_ret, (Object)_4_key, (Object)_6_value);
            ++_2_i;
        }
        output = _1_ret;
        return output;
    }

    public static void PrintEncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> ec, DafnySequence<? extends Character> name) {
        DafnySequence _0_keys = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)uint8._typeDescriptor(), (DafnySet)ec.keySet(), __default::ByteLess);
        System.out.print(name.verbatimString());
        System.out.print(DafnySequence.asString((String)" := {\n").verbatimString());
        BigInteger _hi0 = BigInteger.valueOf(_0_keys.length());
        BigInteger _1_i = BigInteger.ZERO;
        while (_1_i.compareTo(_hi0) < 0) {
            Result _2_valueOrError0 = Result.Default((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _2_valueOrError0 = UTF8.__default.Decode((DafnySequence)((DafnySequence)_0_keys.select(Helpers.toInt((BigInteger)_1_i))));
            if (_2_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                throw new DafnyHaltException("dafny/StructuredEncryption/src/Util.dfy(316,17): " + String.valueOf(_2_valueOrError0));
            }
            DafnySequence _3_key = (DafnySequence)_2_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            Result _4_valueOrError1 = Result.Default((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _4_valueOrError1 = UTF8.__default.Decode((DafnySequence)((DafnySequence)ec.get((Object)((DafnySequence)_0_keys.select(Helpers.toInt((BigInteger)_1_i))))));
            if (_4_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
                throw new DafnyHaltException("dafny/StructuredEncryption/src/Util.dfy(317,19): " + String.valueOf(_4_valueOrError1));
            }
            DafnySequence _5_value = (DafnySequence)_4_valueOrError1.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
            System.out.print(DafnySequence.asString((String)"  ").verbatimString());
            System.out.print(_3_key.verbatimString());
            System.out.print(DafnySequence.asString((String)" := ").verbatimString());
            System.out.print(_5_value.verbatimString());
            System.out.print(DafnySequence.asString((String)"\n").verbatimString());
            _1_i = _1_i.add(BigInteger.ONE);
        }
        System.out.print(DafnySequence.asString((String)"}\n").verbatimString());
    }

    public static DafnySequence<? extends Byte> EncodeTerminal(StructuredDataTerminal t) {
        DafnySequence _0_base = Base64_Compile.__default.Encode((DafnySequence)DafnySequence.concatenate(t.dtor_typeId(), t.dtor_value()));
        return (DafnySequence)UTF8.__default.Encode((DafnySequence)_0_base).dtor_value();
    }

    public static Result<StructuredDataTerminal, DafnySequence<? extends Character>> DecodeTerminal(DafnySequence<? extends Byte> t) {
        Result _0_valueOrError0 = UTF8.__default.Decode(t);
        if (_0_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _0_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), StructuredDataTerminal._typeDescriptor());
        }
        DafnySequence _1_utf8DecodedVal = (DafnySequence)_0_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Result _2_valueOrError1 = Base64_Compile.__default.Decode((DafnySequence)_1_utf8DecodedVal);
        if (_2_valueOrError1.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _2_valueOrError1.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), StructuredDataTerminal._typeDescriptor());
        }
        DafnySequence _3_base64DecodedVal = (DafnySequence)_2_valueOrError1.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR));
        Outcome _4_valueOrError2 = Wrappers_Compile.__default.Need((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Long.compareUnsigned(_3_base64DecodedVal.cardinalityInt(), 2L) >= 0 ? 1 : 0) != 0, (Object)DafnySequence.asString((String)"Invalid serialization of DDB Attribute in encryption context."));
        if (_4_valueOrError2.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR))) {
            return _4_valueOrError2.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), StructuredDataTerminal._typeDescriptor());
        }
        DafnySequence _5_typeId = _3_base64DecodedVal.take(2);
        DafnySequence _6_serializedValue = _3_base64DecodedVal.drop(2);
        return Result.create_Success(StructuredDataTerminal._typeDescriptor(), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (Object)StructuredDataTerminal.create((DafnySequence<? extends Byte>)_6_serializedValue, (DafnySequence<? extends Byte>)_5_typeId));
    }

    public static DafnySequence<? extends Character> ReservedPrefix() {
        return DafnySequence.asString((String)"aws_dbe_");
    }

    public static DafnySequence<? extends Character> HeaderField() {
        return DafnySequence.concatenate(__default.ReservedPrefix(), (DafnySequence)DafnySequence.asString((String)"head"));
    }

    public static DafnySequence<? extends Character> FooterField() {
        return DafnySequence.concatenate(__default.ReservedPrefix(), (DafnySequence)DafnySequence.asString((String)"foot"));
    }

    public static DafnySequence<? extends PathSegment> HeaderPath() {
        return DafnySequence.of(PathSegment._typeDescriptor(), (Object[])new PathSegment[]{PathSegment.create(StructureSegment.create(__default.HeaderField()))});
    }

    public static DafnySequence<? extends PathSegment> FooterPath() {
        return DafnySequence.of(PathSegment._typeDescriptor(), (Object[])new PathSegment[]{PathSegment.create(StructureSegment.create(__default.FooterField()))});
    }

    public static DafnySequence<? extends DafnySequence<? extends PathSegment>> HeaderPaths() {
        return DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(PathSegment._typeDescriptor()), (Object[])new DafnySequence[]{__default.HeaderPath(), __default.FooterPath()});
    }

    public static DafnySequence<? extends Character> ReservedCryptoContextPrefixString() {
        return DafnySequence.asString((String)"aws-crypto-");
    }

    public static DafnySequence<? extends Byte> ReservedCryptoContextPrefixUTF8() {
        DafnySequence _0_s = DafnySequence.of((byte[])new byte[]{97, 119, 115, 45, 99, 114, 121, 112, 116, 111, 45});
        return _0_s;
    }

    public static DafnySequence<? extends Character> ATTR__PREFIX() {
        return DafnySequence.concatenate(__default.ReservedCryptoContextPrefixString(), (DafnySequence)DafnySequence.asString((String)"attr."));
    }

    public static DafnySequence<? extends Byte> EC__ATTR__PREFIX() {
        DafnySequence _0_s = DafnySequence.of((byte[])new byte[]{97, 119, 115, 45, 99, 114, 121, 112, 116, 111, 45, 97, 116, 116, 114, 46});
        return _0_s;
    }

    public static DafnySequence<? extends Character> LEGEND() {
        return DafnySequence.concatenate(__default.ReservedCryptoContextPrefixString(), (DafnySequence)DafnySequence.asString((String)"legend"));
    }

    public static DafnySequence<? extends Byte> LEGEND__UTF8() {
        DafnySequence _0_s = DafnySequence.of((byte[])new byte[]{97, 119, 115, 45, 99, 114, 121, 112, 116, 111, 45, 108, 101, 103, 101, 110, 100});
        return _0_s;
    }

    public static DafnySequence<? extends Character> NULL__STR() {
        return DafnySequence.asString((String)"null");
    }

    public static DafnySequence<? extends Byte> NULL__UTF8() {
        DafnySequence _0_s = DafnySequence.of((byte[])new byte[]{110, 117, 108, 108});
        return _0_s;
    }

    public static DafnySequence<? extends Character> TRUE__STR() {
        return DafnySequence.asString((String)"true");
    }

    public static DafnySequence<? extends Byte> TRUE__UTF8() {
        DafnySequence _0_s = DafnySequence.of((byte[])new byte[]{116, 114, 117, 101});
        return _0_s;
    }

    public static DafnySequence<? extends Character> FALSE__STR() {
        return DafnySequence.asString((String)"false");
    }

    public static DafnySequence<? extends Byte> FALSE__UTF8() {
        DafnySequence _0_s = DafnySequence.of((byte[])new byte[]{102, 97, 108, 115, 101});
        return _0_s;
    }

    public static DafnySequence<? extends Byte> BYTES__TYPE__ID() {
        return DafnySequence.of((byte[])new byte[]{-1, -1});
    }

    public static byte TERM__T() {
        return 0;
    }

    public static byte NULL__T() {
        return 0;
    }

    public static DafnySequence<? extends Byte> NULL() {
        return DafnySequence.of((byte[])new byte[]{__default.TERM__T(), __default.NULL__T()});
    }

    public static byte STRING__T() {
        return 1;
    }

    public static DafnySequence<? extends Byte> STRING() {
        return DafnySequence.of((byte[])new byte[]{__default.TERM__T(), __default.STRING__T()});
    }

    public static byte NUMBER__T() {
        return 2;
    }

    public static DafnySequence<? extends Byte> NUMBER() {
        return DafnySequence.of((byte[])new byte[]{__default.TERM__T(), __default.NUMBER__T()});
    }

    public static byte BOOLEAN__T() {
        return 4;
    }

    public static DafnySequence<? extends Byte> BOOLEAN() {
        return DafnySequence.of((byte[])new byte[]{__default.TERM__T(), __default.BOOLEAN__T()});
    }

    public static byte SET__T() {
        return 1;
    }

    public static DafnySequence<? extends Byte> STRING__SET() {
        return DafnySequence.of((byte[])new byte[]{__default.SET__T(), __default.STRING__T()});
    }

    public static DafnySequence<? extends Byte> NUMBER__SET() {
        return DafnySequence.of((byte[])new byte[]{__default.SET__T(), __default.NUMBER__T()});
    }

    public static byte BINARY__T() {
        return -1;
    }

    public static DafnySequence<? extends Byte> BINARY__SET() {
        return DafnySequence.of((byte[])new byte[]{__default.SET__T(), __default.BINARY__T()});
    }

    public static byte MAP__T() {
        return 2;
    }

    public static DafnySequence<? extends Byte> MAP() {
        return DafnySequence.of((byte[])new byte[]{__default.MAP__T(), __default.NULL__T()});
    }

    public static byte LIST__T() {
        return 3;
    }

    public static DafnySequence<? extends Byte> LIST() {
        return DafnySequence.of((byte[])new byte[]{__default.LIST__T(), __default.NULL__T()});
    }

    public static char LEGEND__STRING() {
        return 'S';
    }

    public static char LEGEND__NUMBER() {
        return 'N';
    }

    public static char LEGEND__LITERAL() {
        return 'L';
    }

    public static char LEGEND__BINARY() {
        return 'B';
    }

    public static long TYPEID__LEN64() {
        return 2L;
    }

    public static long KeySize64() {
        return 32L;
    }

    public static long NonceSize64() {
        return 12L;
    }

    public static long AuthTagSize64() {
        return 16L;
    }

    public static long MSGID__LEN64() {
        return 32L;
    }

    public static byte DbeAlgorithmFamily() {
        return 103;
    }

    public static DafnySequence<? extends Byte> BINARY() {
        return DafnySequence.of((byte[])new byte[]{-1, -1});
    }

    public String toString() {
        return "StructuredEncryptionUtil._default";
    }
}

