/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.env.Environment;
import org.opensearch.ingest.AbstractBatchingProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.TextEmbeddingProcessor;
import org.opensearch.neuralsearch.processor.optimization.TextEmbeddingInferenceFilter;
import org.opensearch.transport.client.OpenSearchClient;

public final class TextEmbeddingProcessorFactory
extends AbstractBatchingProcessor.Factory {
    private final OpenSearchClient openSearchClient;
    private final MLCommonsClientAccessor clientAccessor;
    private final Environment environment;
    private final ClusterService clusterService;

    public TextEmbeddingProcessorFactory(OpenSearchClient openSearchClient, MLCommonsClientAccessor clientAccessor, Environment environment, ClusterService clusterService) {
        super("text_embedding");
        this.openSearchClient = openSearchClient;
        this.clientAccessor = clientAccessor;
        this.environment = environment;
        this.clusterService = clusterService;
    }

    protected AbstractBatchingProcessor newProcessor(String tag, String description, int batchSize, Map<String, Object> config) {
        boolean skipExisting;
        String modelId = ConfigurationUtils.readStringProperty((String)"text_embedding", (String)tag, config, (String)"model_id");
        Map fieldMap = ConfigurationUtils.readMap((String)"text_embedding", (String)tag, config, (String)"field_map");
        return new TextEmbeddingProcessor(tag, description, batchSize, modelId, fieldMap, skipExisting, (skipExisting = ConfigurationUtils.readBooleanProperty((String)"text_embedding", (String)tag, config, (String)"skip_existing", (boolean)false)) ? new TextEmbeddingInferenceFilter(fieldMap) : null, this.openSearchClient, this.clientAccessor, this.environment, this.clusterService);
    }
}

