/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;

public class MLMemoryContainer
implements ToXContentObject,
Writeable {
    private String name;
    private String description;
    private User owner;
    private String tenantId;
    private Instant createdTime;
    private Instant lastUpdatedTime;
    private MemoryConfiguration configuration;
    private List<String> backendRoles;

    public MLMemoryContainer(String name, String description, User owner, String tenantId, Instant createdTime, Instant lastUpdatedTime, MemoryConfiguration configuration, List<String> backendRoles) {
        this.name = name;
        this.description = description;
        this.owner = owner;
        this.tenantId = tenantId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.configuration = configuration == null ? MemoryConfiguration.builder().build() : configuration;
        this.backendRoles = backendRoles;
    }

    public MLMemoryContainer(StreamInput input) throws IOException {
        this.name = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.owner = new User(input);
        }
        this.tenantId = input.readOptionalString();
        this.createdTime = input.readOptionalInstant();
        this.lastUpdatedTime = input.readOptionalInstant();
        if (input.readBoolean()) {
            this.configuration = new MemoryConfiguration(input);
        }
        if (input.readBoolean()) {
            this.backendRoles = input.readStringList();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdatedTime);
        if (this.configuration != null) {
            out.writeBoolean(true);
            this.configuration.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.owner != null) {
            builder.field("owner", (ToXContent)this.owner);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdatedTime != null) {
            builder.field("last_updated_time", this.lastUpdatedTime.toEpochMilli());
        }
        if (this.configuration != null) {
            builder.field("configuration", (ToXContent)this.configuration);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            builder.field("backend_roles", this.backendRoles);
        }
        builder.endObject();
        return builder;
    }

    public static MLMemoryContainer parse(XContentParser parser) throws IOException {
        String name = null;
        String description = null;
        User owner = null;
        String tenantId = null;
        Instant createdTime = null;
        Instant lastUpdatedTime = null;
        MemoryConfiguration configuration = null;
        ArrayList<String> backendRoles = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block20;
                }
                case "description": {
                    description = parser.text();
                    continue block20;
                }
                case "owner": {
                    owner = User.parse((XContentParser)parser);
                    continue block20;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block20;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block20;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block20;
                }
                case "configuration": {
                    configuration = MemoryConfiguration.parse(parser);
                    continue block20;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return MLMemoryContainer.builder().name(name).description(description).owner(owner).tenantId(tenantId).createdTime(createdTime).lastUpdatedTime(lastUpdatedTime).configuration(configuration).backendRoles(backendRoles).build();
    }

    @Generated
    public static MLMemoryContainerBuilder builder() {
        return new MLMemoryContainerBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public User getOwner() {
        return this.owner;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public MemoryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastUpdatedTime(Instant lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    @Generated
    public void setConfiguration(MemoryConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLMemoryContainer)) {
            return false;
        }
        MLMemoryContainer other = (MLMemoryContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        User this$owner = this.getOwner();
        User other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Instant this$lastUpdatedTime = this.getLastUpdatedTime();
        Instant other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        MemoryConfiguration this$configuration = this.getConfiguration();
        MemoryConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        return !(this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLMemoryContainer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        User $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Instant $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Instant $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        MemoryConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result = result * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        return result;
    }

    @Generated
    public static class MLMemoryContainerBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private User owner;
        @Generated
        private String tenantId;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdatedTime;
        @Generated
        private MemoryConfiguration configuration;
        @Generated
        private List<String> backendRoles;

        @Generated
        MLMemoryContainerBuilder() {
        }

        @Generated
        public MLMemoryContainerBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder owner(User owner) {
            this.owner = owner;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder configuration(MemoryConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLMemoryContainer build() {
            return new MLMemoryContainer(this.name, this.description, this.owner, this.tenantId, this.createdTime, this.lastUpdatedTime, this.configuration, this.backendRoles);
        }

        @Generated
        public String toString() {
            return "MLMemoryContainer.MLMemoryContainerBuilder(name=" + this.name + ", description=" + this.description + ", owner=" + String.valueOf(this.owner) + ", tenantId=" + this.tenantId + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", configuration=" + String.valueOf(this.configuration) + ", backendRoles=" + String.valueOf(this.backendRoles) + ")";
        }
    }
}

