/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.invocation.proxy.reflection.ClassMetadataSource;

public class DefaultClassMetadataSource
implements ClassMetadataSource {
    private final Class<?> clazz;
    private final List<Method> declaredMethods;
    private final List<Constructor<?>> constructors;

    public DefaultClassMetadataSource(Class<?> clazz) {
        this.clazz = clazz;
        this.declaredMethods = Arrays.asList(clazz.getDeclaredMethods());
        this.constructors = Arrays.asList(clazz.getConstructors());
    }

    @Override
    public Collection<Method> getDeclaredMethods() {
        return this.declaredMethods;
    }

    @Override
    public Method getMethod(String methodName, Class<?> returnType, Class<?> ... parameters) throws NoSuchMethodException {
        for (Method method : this.declaredMethods) {
            if (!method.getName().equals(methodName) || !returnType.equals(method.getReturnType()) || !Arrays.equals(method.getParameterTypes(), parameters)) continue;
            return method;
        }
        throw new NoSuchMethodException("Could not find method " + methodName + " on " + this.clazz);
    }

    @Override
    public Collection<Constructor<?>> getConstructors() {
        return this.constructors;
    }
}

