/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Distance;
import tim.prune.data.Unit;

public class ScaleBar
extends JPanel {
    private final Config _config;
    private int _zoomLevel = -1;
    private double _yPos = 0.0;
    private double _displayScaling = 1.0;
    private static final int INVALID_SCALE = 0;

    public ScaleBar(Config config) {
        this._config = config;
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(100, 20));
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._zoomLevel < 2) {
            return;
        }
        Unit unit = this._config.getUnitSet().getDistanceUnit();
        double d = this.getPixelsPerDist(unit);
        int n = ScaleBar.getScaleToUse(d);
        if (n != 0) {
            int n2 = ScaleBar.getBarWidth(d, n);
            this.paintScaleBar(graphics, n, n2);
        }
    }

    private double getPixelsPerDist(Unit unit) {
        double d = Math.PI * (1.0 - 2.0 * this._yPos);
        double d2 = Math.atan(Math.sinh(d));
        double d3 = Distance.convertRadiansToDistance(Math.PI * 2, unit) * Math.cos(d2);
        return (double)(256 << this._zoomLevel) / d3 / this._displayScaling;
    }

    private static int getScaleToUse(double d) {
        int[] nArray;
        int[] nArray2 = nArray = new int[]{10000, 5000, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 1, -2, -5, -10, -20, -50, -100, -200};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            int n4 = ScaleBar.getBarWidth(d, n3);
            if (n4 <= 280) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    private static int getBarWidth(double d, int n) {
        double d2 = (n > 0 ? (double)n : -1.0 / (double)n) * d;
        return (int)d2;
    }

    private void paintScaleBar(Graphics graphics, int n, int n2) {
        Color color = this._config.getColourScheme().getColour(3);
        Color color2 = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        int n3 = 20 + n2;
        graphics.setColor(color2);
        graphics.drawLine(20, 9, n3 + 2, 9);
        graphics.drawLine(20, 12, n3 + 2, 12);
        graphics.drawLine(19, 12, 19, 5);
        graphics.drawLine(22, 12, 22, 5);
        graphics.drawLine(n3 - 1, 12, n3 - 1, 5);
        graphics.drawLine(n3 + 2, 12, n3 + 2, 5);
        graphics.setColor(color);
        graphics.drawLine(20, 10, n3, 10);
        graphics.drawLine(20, 11, n3, 11);
        graphics.drawLine(20, 10, 20, 5);
        graphics.drawLine(21, 10, 21, 5);
        graphics.drawLine(n3, 11, n3, 5);
        graphics.drawLine(n3 + 1, 11, n3 + 1, 5);
        String string = ScaleBar.getScaleText(n, this._config.getUnitSet().getDistanceUnit());
        graphics.setColor(color2);
        graphics.drawString(string, n3 + 8 - 1, 10);
        graphics.drawString(string, n3 + 8 + 1, 10);
        graphics.drawString(string, n3 + 8, 9);
        graphics.drawString(string, n3 + 8, 11);
        graphics.setColor(color);
        graphics.drawString(string, n3 + 8, 10);
    }

    private static String getScaleText(int n, Unit unit) {
        if (n > 0) {
            return n + " " + I18nManager.getText(unit.getShortnameKey());
        }
        return -1.0 / (double)n + " " + I18nManager.getText(unit.getShortnameKey());
    }

    public void updateScale(int n, double d) {
        this._zoomLevel = n;
        this._yPos = d;
    }

    public void setDisplayScaling(double d) {
        this._displayScaling = d;
    }
}

