/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.common.av.AudioSink;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.StringUtil;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.shapes.ImageButton;
import com.jogamp.graph.ui.shapes.Label;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.graph.ui.shapes.TexSeqButton;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.av.CodecID;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.SubBitmapEvent;
import com.jogamp.opengl.util.av.SubTextEvent;
import com.jogamp.opengl.util.av.SubtitleEvent;
import com.jogamp.opengl.util.av.SubtitleEventListener;
import com.jogamp.opengl.util.texture.ImageSequence;
import java.util.ArrayList;
import java.util.List;

public class MediaButton
extends TexSeqButton {
    private static final boolean DEBUG_SUB = false;
    private static final boolean DEBUG_SUB_LAYOUT = false;
    private boolean verbose = false;
    private Font subFont;
    private Font subFallbackFont;
    private final Label subLabel;
    private final float subZOffset;
    private boolean subEnabled;
    private float subLineHeightPct;
    private float subLineDY;
    private Alignment subAlignment;
    private final Rectangle subBlend;
    private final ImageButton subTexImg;
    public static final float DEFAULT_ASS_SUB_HEIGHT = 0.075f;
    public static final float DEFAULT_ASS_SUB_POS = 0.25f;
    public static final Vec4f DEFAULT_ASS_SUB_COLOR = new Vec4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final float DEFAULT_ASS_SUB_BLEND = 0.3f;
    public static final Alignment DEFAULT_ASS_SUB_ALIGNMENT = Alignment.CenterHoriz;
    private static final float ASS_SUB_USED_WIDTH = 0.9f;
    private static final float ASS_SUB_BLEND_ADDED_HEIGHT = 0.25f;
    private static final int ASS_SUB_MAX_SPLIT_LINES = 4;
    private SubtitleEvent drawLastSub;
    private final List<SubtitleEvent> subEventQueue = new ArrayList<SubtitleEvent>();
    private final Object subEventLock = new Object();
    private final SubtitleEventListener subEventListener = new SubtitleEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(SubtitleEvent subtitleEvent) {
            Object object = MediaButton.this.subEventLock;
            synchronized (object) {
                MediaButton.this.subEventQueue.add(subtitleEvent);
            }
        }
    };
    private final GLMediaPlayer.GLMediaEventListener defGLMediaEventListener = new GLMediaPlayer.GLMediaEventListener(){

        @Override
        public void attributesChanged(final GLMediaPlayer gLMediaPlayer, GLMediaPlayer.EventMask eventMask, long l) {
            GLMediaPlayer.StreamException streamException;
            if (MediaButton.this.verbose) {
                System.err.println("MediaButton AttributesChanges: " + eventMask + ", when " + l);
                System.err.println("MediaButton State: " + gLMediaPlayer);
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Init)) {
                MediaButton.this.clearSubtitleCache();
                MediaButton.this.resetGL = true;
            } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Uninit) || eventMask.isSet(GLMediaPlayer.EventMask.Bit.Play) || eventMask.isSet(GLMediaPlayer.EventMask.Bit.Seek) || eventMask.isSet(GLMediaPlayer.EventMask.Bit.SID)) {
                MediaButton.this.clearSubtitleCache();
                MediaButton.this.markStateDirty();
            } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Pause)) {
                MediaButton.this.clearSubtitleCacheButLast();
                MediaButton.this.markStateDirty();
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Size)) {
                // empty if block
            }
            if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
                new InterruptSource.Thread(){

                    public void run() {
                        gLMediaPlayer.seek(0);
                        gLMediaPlayer.resume();
                    }
                }.start();
            } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Error) && null != (streamException = gLMediaPlayer.getStreamException())) {
                streamException.printStackTrace();
            }
        }
    };
    volatile boolean resetGL = true;

    public MediaButton(int n, float f, float f2, GLMediaPlayer gLMediaPlayer) {
        this(n, f, f2, gLMediaPlayer, null);
    }

    public MediaButton(int n, float f, float f2, GLMediaPlayer gLMediaPlayer, Font font) {
        super(n & 0xFFFFFFFC, f, f2, gLMediaPlayer);
        this.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.setPressedColorMod(0.9f, 0.9f, 0.9f, 0.7f);
        this.setToggleOffColorMod(0.8f, 0.8f, 0.8f, 1.0f);
        this.setToggleOnColorMod(1.0f, 1.0f, 1.0f, 1.0f);
        gLMediaPlayer.setSubtitleEventListener(this.subEventListener);
        this.setSubtitleParams(font, 0.075f, 0.25f, DEFAULT_ASS_SUB_ALIGNMENT);
        this.subLabel = new Label(n, this.subFont, "");
        this.subZOffset = 1.53E-4f;
        this.subLabel.moveTo(0.0f, 0.0f, this.subZOffset);
        this.subBlend = new Rectangle(n, 1.0f, 1.0f, 0.0f);
        this.setSubtitleColor(DEFAULT_ASS_SUB_COLOR, 0.3f);
        this.subTexImg = new ImageButton(n, f, f2, new ImageSequence(gLMediaPlayer.getTextureUnit(), true));
        this.subTexImg.setPerp().setToggleable(false).setDragAndResizable(false).setInteractive(false);
        this.subTexImg.getImageSequence().setParams(9729, 9729, 33071, 33071);
        this.subTexImg.setARatioAdjustment(false);
        this.drawLastSub = null;
    }

    public void setSubtitlesEnabled(boolean bl) {
        this.subEnabled = bl;
    }

    public void setSubtitleParams(Font font, float f, float f2, Alignment alignment) {
        this.subFont = null != font ? font : FontFactory.getDefaultFont();
        this.subFallbackFont = FontFactory.getFallbackFont();
        this.subLineHeightPct = f;
        this.subLineDY = f2;
        this.subAlignment = alignment;
        this.subEnabled = true;
    }

    public void setSubtitleColor(Vec4f vec4f, float f) {
        this.subLabel.setColor(vec4f);
        this.subBlend.setColor(0.0f, 0.0f, 0.0f, f);
    }

    public final SubtitleEventListener getSubEventListener() {
        return this.subEventListener;
    }

    public MediaButton setVerbose(boolean bl) {
        this.verbose = bl;
        return this;
    }

    public MediaButton addDefaultEventListener() {
        this.getGLMediaPlayer().addEventListener(this.defGLMediaEventListener);
        return this;
    }

    public final GLMediaPlayer getGLMediaPlayer() {
        return (GLMediaPlayer)this.texSeq;
    }

    public final AudioSink getAudioSink() {
        return this.getGLMediaPlayer().getAudioSink();
    }

    @Override
    protected void clearImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        ((GLMediaPlayer)this.texSeq).stop();
        ((GLMediaPlayer)this.texSeq).seek(0);
        this.clearSubtitleCache();
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        ((GLMediaPlayer)this.texSeq).stop();
        this.clearSubtitleCache();
        this.subTexImg.destroy(gL2ES2, regionRenderer);
        this.subLabel.destroy(gL2ES2, regionRenderer);
        this.subBlend.destroy(gL2ES2, regionRenderer);
        ((GLMediaPlayer)this.texSeq).destroy(gL2ES2);
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        super.addShapeToRegion(gLProfile, gL2ES2);
    }

    @Override
    protected final void drawImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Vec4f vec4f) {
        GLMediaPlayer gLMediaPlayer = (GLMediaPlayer)this.texSeq;
        if (this.resetGL) {
            this.resetGL = false;
            try {
                this.clearSubtitleCache();
                gLMediaPlayer.initGL(gL2ES2);
                if (null != this.region) {
                    this.region.markShapeDirty();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.drawImpl0(gL2ES2, regionRenderer, vec4f);
        if (this.subEnabled && -2 != gLMediaPlayer.getSID()) {
            this.drawSubtitle(gL2ES2, regionRenderer);
        }
        if (GLMediaPlayer.State.Playing == gLMediaPlayer.getState()) {
            this.markStateDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearSubtitleCache() {
        Object object = this.subEventLock;
        synchronized (object) {
            SubtitleEvent subtitleEvent = this.drawLastSub;
            this.drawLastSub = null;
            if (null != subtitleEvent) {
                subtitleEvent.release();
            }
            this.subTexImg.getImageSequence().removeAllFrames();
            for (SubtitleEvent subtitleEvent2 : this.subEventQueue) {
                subtitleEvent2.release();
            }
            this.subEventQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearSubtitleCacheButLast() {
        Object object = this.subEventLock;
        synchronized (object) {
            SubtitleEvent subtitleEvent = this.drawLastSub;
            for (int i = this.subEventQueue.size() - 1; i >= 0; --i) {
                SubtitleEvent subtitleEvent2 = this.subEventQueue.get(i);
                if (subtitleEvent == subtitleEvent2) continue;
                subtitleEvent2.release();
                this.subEventQueue.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawSubtitle(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        boolean bl;
        SubtitleEvent subtitleEvent;
        SubtitleEvent subtitleEvent2;
        Object object;
        GLMediaPlayer gLMediaPlayer = (GLMediaPlayer)this.texSeq;
        int n = gLMediaPlayer.getPTS().getCurrent();
        SubtitleEvent subtitleEvent3 = this.drawLastSub;
        if (null != subtitleEvent3 && subtitleEvent3.pts_end < n) {
            this.drawLastSub = null;
            subtitleEvent3.release();
            subtitleEvent3 = null;
        }
        Object object2 = this.subEventLock;
        synchronized (object2) {
            if (this.subEventQueue.size() > 0) {
                object = this.subEventQueue.get(0);
                if (((SubtitleEvent)object).pts_start <= n && n <= ((SubtitleEvent)object).pts_end) {
                    subtitleEvent2 = object;
                    this.subEventQueue.remove(0);
                } else if (((SubtitleEvent)object).pts_end < n) {
                    subtitleEvent2 = null;
                    this.subEventQueue.remove(0);
                    ((SubtitleEvent)object).release();
                } else {
                    subtitleEvent2 = null;
                }
            } else {
                subtitleEvent2 = null;
            }
        }
        if (null == subtitleEvent2) {
            subtitleEvent = subtitleEvent3;
            bl = false;
        } else {
            if (null != subtitleEvent3) {
                subtitleEvent3.release();
            }
            subtitleEvent3 = null;
            if (SubtitleEvent.Type.Empty == subtitleEvent2.type) {
                subtitleEvent2.release();
                subtitleEvent = null;
                bl = false;
            } else {
                this.drawLastSub = subtitleEvent2;
                subtitleEvent = subtitleEvent2;
                bl = true;
            }
        }
        if (null == subtitleEvent) {
            this.drawLastSub = null;
        } else if (SubtitleEvent.Type.Text == subtitleEvent.type) {
            subtitleEvent2 = (SubTextEvent)subtitleEvent;
            if (bl) {
                Vec2f vec2f;
                float f = this.box.getWidth() * 0.9f;
                this.subLabel.setFont(Font.getBestCoverage(this.subFont, this.subFallbackFont, ((SubTextEvent)subtitleEvent2).text));
                this.subLabel.setText(((SubTextEvent)subtitleEvent2).text);
                int n2 = ((SubTextEvent)subtitleEvent2).lines;
                AABBox aABBox = this.subLabel.getBounds(gL2ES2.getGLProfile());
                float f2 = aABBox.getHeight() / (float)n2;
                float f3 = this.box.getHeight() * this.subLineHeightPct;
                float f4 = f3 / f2;
                if (f4 * aABBox.getWidth() > f) {
                    String string = StringUtil.trim((String)((SubTextEvent)subtitleEvent2).text, (String)StringUtil.WHITESPACE, (String)" ");
                    n2 = Math.min(4, (int)Math.ceil(f4 * aABBox.getWidth() / f));
                    String string2 = StringUtil.split((String)string, (int)n2, (String)" ", (String)String.valueOf('\n'));
                    n2 = StringUtil.getLineCount((CharSequence)string2);
                    this.subLabel.setText(string2);
                    aABBox = this.subLabel.getBounds(gL2ES2.getGLProfile());
                    f2 = aABBox.getHeight() / (float)n2;
                    f3 = this.box.getHeight() * this.subLineHeightPct;
                    f4 = f3 / f2;
                    if (f4 * aABBox.getWidth() > f) {
                        f4 = f / aABBox.getWidth();
                        f3 *= f4 / (f3 / f2);
                    }
                }
                this.subLabel.setScale(f4, f4, 1.0f);
                float f5 = f3 * (float)n2;
                float f6 = f5 + f3 * 0.25f;
                Vec2f vec2f2 = new Vec2f(gLMediaPlayer.getWidth(), gLMediaPlayer.getHeight());
                Vec2f vec2f3 = new Vec2f(this.box.getWidth(), this.box.getHeight()).div(vec2f2);
                float f7 = Math.min(vec2f3.x(), vec2f3.y());
                Vec2f vec2f4 = new Vec2f(vec2f2).scale(0.5f);
                Vec2f vec2f5 = new Vec2f(this.box.getCenter()).scale(1.0f / f7);
                float f8 = (f6 - f5) * 0.5f;
                float f9 = vec2f2.x() * 0.9f;
                float f10 = vec2f2.x() - f9;
                if (this.subAlignment.isSet(Alignment.Bit.Left)) {
                    Vec2f vec2f6 = new Vec2f(f10 * 0.5f, f2 * this.subLineDY * f4 / f7);
                    vec2f = vec2f6.sub(vec2f4).add(vec2f5).scale(f7).add(0.0f, f8);
                } else {
                    Vec2f vec2f7 = new Vec2f(f10 * 0.5f + (f9 - aABBox.getWidth() * f4 / f7) * 0.5f, f2 * this.subLineDY * f4 / f7);
                    vec2f = vec2f7.sub(vec2f4).add(vec2f5).scale(f7).add(0.0f, f8);
                }
                this.subLabel.moveTo(vec2f.x(), vec2f.y(), 2.0f * this.subZOffset);
                this.subBlend.setDimension(this.box.getWidth(), f6, 0.0f);
                this.subBlend.setPosition(0.0f, vec2f.y() - f8, 1.0f * this.subZOffset);
            }
            this.subBlend.draw(gL2ES2, regionRenderer);
            PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
            pMVMatrix4f.pushMv();
            this.subLabel.applyMatToMv(pMVMatrix4f);
            this.subLabel.draw(gL2ES2, regionRenderer);
            pMVMatrix4f.popMv();
        } else if (SubtitleEvent.Type.Bitmap == subtitleEvent.type) {
            subtitleEvent2 = (SubBitmapEvent)subtitleEvent;
            if (bl && null != ((SubBitmapEvent)subtitleEvent2).texture) {
                object2 = this.subTexImg.getImageSequence();
                ((ImageSequence)object2).removeAllFrames();
                ((ImageSequence)object2).addFrame((GL)gL2ES2, ((SubBitmapEvent)subtitleEvent2).texture);
                object = new Vec2f(gLMediaPlayer.getWidth(), gLMediaPlayer.getHeight());
                Vec2f vec2f = new Vec2f(this.box.getWidth(), this.box.getHeight()).div((Vec2f)object);
                float f = Math.min(vec2f.x(), vec2f.y());
                Vec2f vec2f8 = new Vec2f(((SubBitmapEvent)subtitleEvent2).dimension).scale(f);
                this.subTexImg.setSize(vec2f8.x(), vec2f8.y());
                Vec2f vec2f9 = CodecID.HDMV_PGS == subtitleEvent.codec && gLMediaPlayer.getWidth() < 1920 && gLMediaPlayer.getHeight() == 1080 ? new Vec2f(new Vec2f(1920.0f, 1080.0f)).scale(0.5f) : new Vec2f((Vec2f)object).scale(0.5f);
                Vec2f vec2f10 = new Vec2f(this.box.getCenter()).scale(1.0f / f);
                Vec2f vec2f11 = new Vec2f(((SubBitmapEvent)subtitleEvent2).position.x(), ((Vec2f)object).y() - (float)((SubBitmapEvent)subtitleEvent2).position.y() - (float)((SubBitmapEvent)subtitleEvent2).dimension.y());
                Vec2f vec2f12 = vec2f11.minus(vec2f9).add(vec2f10).scale(f);
                this.subTexImg.moveTo(vec2f12.x(), vec2f12.y(), 2.0f * this.subZOffset);
            }
            object2 = regionRenderer.getMatrix();
            ((PMVMatrix4f)object2).pushMv();
            this.subTexImg.applyMatToMv((PMVMatrix4f)object2);
            this.subTexImg.draw(gL2ES2, regionRenderer);
            ((PMVMatrix4f)object2).popMv();
        }
    }
}

