/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassCollector;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;

public class TypedReferenceValue
extends ReferenceValue {
    private static final boolean ALLOW_INCOMPLETE_CLASS_HIERARCHY = System.getProperty("allow.incomplete.class.hierarchy") != null;
    private static final boolean DEBUG = false;
    protected final String type;
    protected final Clazz referencedClass;
    protected final boolean mayBeExtension;
    protected final boolean mayBeNull;

    public TypedReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        this.type = type;
        this.referencedClass = referencedClass;
        this.mayBeExtension = mayBeExtension;
        this.mayBeNull = mayBeNull;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Clazz getReferencedClass() {
        return this.referencedClass;
    }

    @Override
    public boolean mayBeExtension() {
        return this.mayBeExtension;
    }

    @Override
    public int isNull() {
        return this.type == null ? 1 : (this.mayBeNull ? 0 : -1);
    }

    @Override
    public int instanceOf(String otherType, Clazz otherReferencedClass) {
        String thisType = this.type;
        if (thisType == null) {
            return -1;
        }
        int thisDimensionCount = ClassUtil.internalArrayTypeDimensionCount(thisType);
        int otherDimensionCount = ClassUtil.internalArrayTypeDimensionCount(otherType);
        int commonDimensionCount = Math.min(thisDimensionCount, otherDimensionCount);
        thisType = thisType.substring(commonDimensionCount);
        otherType = otherType.substring(commonDimensionCount);
        if (commonDimensionCount > 0 && (ClassUtil.isInternalPrimitiveType(thisType.charAt(0)) || ClassUtil.isInternalPrimitiveType(otherType.charAt(0)))) {
            return !thisType.equals(otherType) ? -1 : (this.mayBeNull ? 0 : 1);
        }
        if (thisDimensionCount == commonDimensionCount) {
            thisType = ClassUtil.internalClassNameFromClassType(thisType);
        }
        if (otherDimensionCount == commonDimensionCount) {
            otherType = ClassUtil.internalClassNameFromClassType(otherType);
        }
        if (thisDimensionCount > otherDimensionCount && !ClassUtil.isInternalArrayInterfaceName(otherType)) {
            return -1;
        }
        if (thisDimensionCount < otherDimensionCount && !ClassUtil.isInternalArrayInterfaceName(thisType)) {
            return -1;
        }
        if (thisType.equals(otherType) || "java/lang/Object".equals(otherType) || thisDimensionCount > otherDimensionCount) {
            return this.mayBeNull ? 0 : 1;
        }
        if (thisDimensionCount < otherDimensionCount) {
            return 0;
        }
        return this.referencedClass == null || otherReferencedClass == null ? 0 : (this.referencedClass.extendsOrImplements(otherReferencedClass) ? (this.mayBeNull ? 0 : 1) : ((this.referencedClass.getAccessFlags() & 0x10) != 0 ? -1 : ((this.referencedClass.getAccessFlags() & 0x200) == 0 && (otherReferencedClass.getAccessFlags() & 0x200) == 0 && !otherReferencedClass.extendsOrImplements(this.referencedClass) ? -1 : 0)));
    }

    @Override
    public ReferenceValue cast(String type, Clazz referencedClass, ValueFactory valueFactory, boolean alwaysCast) {
        return this.type != null && this.type.equals(type) || !alwaysCast && (this.type == null || this.instanceOf(type, referencedClass) == 1) ? this : valueFactory.createReferenceValue(type, referencedClass, true, this.mayBeNull);
    }

    public ReferenceValue generalizeMayBeNull(boolean mayBeNull) {
        return this.mayBeNull == mayBeNull ? this : new TypedReferenceValue(this.type, this.referencedClass, this.mayBeExtension, true);
    }

    @Override
    public ReferenceValue referenceArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        return this.type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : (!ClassUtil.isInternalArrayType(this.type) ? TypedReferenceValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : valueFactory.createValue(this.type.substring(1), this.referencedClass, true, true).referenceValue());
    }

    @Override
    public ReferenceValue generalize(ReferenceValue other) {
        return other.generalize(this);
    }

    @Override
    public int equal(ReferenceValue other) {
        return other.equal(this);
    }

    @Override
    public ReferenceValue generalize(TypedReferenceValue other) {
        boolean mayBeNull;
        if (this.equals(other)) {
            return this;
        }
        String thisType = this.type;
        String otherType = other.type;
        if (thisType == null && otherType == null) {
            return TypedReferenceValueFactory.REFERENCE_VALUE_NULL;
        }
        if (thisType == null) {
            return other.generalizeMayBeNull(true);
        }
        if (otherType == null) {
            return this.generalizeMayBeNull(true);
        }
        boolean mayBeExtension = this.mayBeExtension || other.mayBeExtension;
        boolean bl = mayBeNull = this.mayBeNull || other.mayBeNull;
        if (thisType.equals(otherType)) {
            return TypedReferenceValue.typedReferenceValue(this, mayBeExtension, mayBeNull);
        }
        int thisDimensionCount = ClassUtil.internalArrayTypeDimensionCount(thisType);
        int otherDimensionCount = ClassUtil.internalArrayTypeDimensionCount(otherType);
        int commonDimensionCount = Math.min(thisDimensionCount, otherDimensionCount);
        if (thisDimensionCount == otherDimensionCount) {
            Clazz thisReferencedClass = this.referencedClass;
            Clazz otherReferencedClass = other.referencedClass;
            if (thisReferencedClass != null && otherReferencedClass != null) {
                if (thisReferencedClass.extendsOrImplements(otherReferencedClass)) {
                    return TypedReferenceValue.typedReferenceValue(other, true, mayBeNull);
                }
                if (otherReferencedClass.extendsOrImplements(thisReferencedClass)) {
                    return TypedReferenceValue.typedReferenceValue(this, true, mayBeNull);
                }
                try {
                    Clazz commonInterface;
                    Clazz commonClass = this.findCommonClass(thisReferencedClass, otherReferencedClass, false);
                    if (commonClass.getName().equals("java/lang/Object") && (commonInterface = this.findCommonClass(thisReferencedClass, otherReferencedClass, true)) != null) {
                        commonClass = commonInterface;
                    }
                    return new TypedReferenceValue(commonDimensionCount == 0 ? commonClass.getName() : ClassUtil.internalArrayTypeFromClassName(commonClass.getName(), commonDimensionCount), commonClass, mayBeExtension, mayBeNull);
                }
                catch (IllegalArgumentException e) {
                    if (ALLOW_INCOMPLETE_CLASS_HIERARCHY) {
                        return BasicValueFactory.REFERENCE_VALUE;
                    }
                    throw e;
                }
            }
        } else if (thisDimensionCount > otherDimensionCount) {
            if (ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(otherType))) {
                return TypedReferenceValue.typedReferenceValue(other, true, mayBeNull);
            }
        } else if (thisDimensionCount < otherDimensionCount && ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(thisType))) {
            return TypedReferenceValue.typedReferenceValue(this, true, mayBeNull);
        }
        if (commonDimensionCount > 0 && (ClassUtil.isInternalPrimitiveType(otherType.charAt(commonDimensionCount)) || ClassUtil.isInternalPrimitiveType(thisType.charAt(commonDimensionCount)))) {
            --commonDimensionCount;
        }
        return commonDimensionCount != 0 ? new TypedReferenceValue(ClassUtil.internalArrayTypeFromClassName("java/lang/Object", commonDimensionCount), null, true, mayBeNull) : (mayBeNull ? TypedReferenceValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : TypedReferenceValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_NOT_NULL);
    }

    private Clazz findCommonClass(Clazz class1, Clazz class2, boolean interfaces) {
        HashSet superClasses1 = new HashSet();
        class1.hierarchyAccept(!interfaces, !interfaces, interfaces, false, new ClassCollector(superClasses1));
        int superClasses1Count = superClasses1.size();
        if (superClasses1Count == 0) {
            if (interfaces) {
                return null;
            }
            if (class1.getSuperName() != null) {
                throw new IllegalArgumentException("Can't find any super classes of [" + class1.getName() + "] (not even immediate super class [" + class1.getSuperName() + "])");
            }
        }
        HashSet superClasses2 = new HashSet();
        class2.hierarchyAccept(!interfaces, !interfaces, interfaces, false, new ClassCollector(superClasses2));
        int superClasses2Count = superClasses2.size();
        if (superClasses2Count == 0) {
            if (interfaces) {
                return null;
            }
            if (class2.getSuperName() != null) {
                throw new IllegalArgumentException("Can't find any super classes of [" + class2.getName() + "] (not even immediate super class [" + class2.getSuperName() + "])");
            }
        }
        superClasses1.retainAll(superClasses2);
        if (interfaces && superClasses1.isEmpty()) {
            return null;
        }
        Clazz commonClass = null;
        int maximumSuperClassCount = -1;
        for (Clazz commonSuperClass : superClasses1) {
            int superClassCount = this.superClassCount(commonSuperClass, superClasses1);
            if (maximumSuperClassCount >= superClassCount && (maximumSuperClassCount != superClassCount || commonClass == null || commonClass.getName().compareTo(commonSuperClass.getName()) <= 0)) continue;
            commonClass = commonSuperClass;
            maximumSuperClassCount = superClassCount;
        }
        if (commonClass == null) {
            for (Clazz clazz : Arrays.asList(class1, class2)) {
                if ("java/lang/Object".equals(clazz.getName())) {
                    commonClass = clazz;
                    break;
                }
                if ((clazz.getAccessFlags() & 0x10) == 0 || !"java/lang/Object".equals(clazz.getSuperName())) continue;
                commonClass = clazz.getSuperClass();
                break;
            }
        }
        if (commonClass == null) {
            throw new IllegalArgumentException("Can't find common super class of [" + class1.getName() + "] (with " + superClasses1Count + " known super classes) and [" + class2.getName() + "] (with " + superClasses2Count + " known super classes)");
        }
        return commonClass;
    }

    private static ReferenceValue typedReferenceValue(TypedReferenceValue referenceValue, boolean mayBeExtension, boolean mayBeNull) {
        return referenceValue.getClass() == TypedReferenceValue.class && referenceValue.mayBeExtension == mayBeExtension ? referenceValue.generalizeMayBeNull(mayBeNull) : new TypedReferenceValue(referenceValue.type, referenceValue.referencedClass, mayBeExtension, mayBeNull);
    }

    private int superClassCount(Clazz subClass, Set classes) {
        int count = 0;
        for (Clazz clazz : classes) {
            if (!subClass.extendsOrImplements(clazz)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int equal(TypedReferenceValue other) {
        return this.type == null ? (other.type == null ? 1 : (other.mayBeNull ? 0 : -1)) : (other.type == null ? (this.mayBeNull ? 0 : -1) : (this.mayBeExtension || other.mayBeExtension || this.type.equals(other.type) ? 0 : -1));
    }

    @Override
    public boolean isParticular() {
        return this.type == null;
    }

    @Override
    public final String internalType() {
        return this.type == null ? "Ljava/lang/Object;" : (ClassUtil.isInternalArrayType(this.type) ? this.type : 'L' + this.type + ';');
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TypedReferenceValue other = (TypedReferenceValue)object;
        return this.type == null ? other.type == null : this.mayBeExtension == other.mayBeExtension && this.mayBeNull == other.mayBeNull && this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ (this.type == null ? 0 : this.type.hashCode() ^ (this.mayBeExtension ? 0 : 1) ^ (this.mayBeNull ? 0 : 2));
    }

    @Override
    public String toString() {
        return this.type == null ? "n" : this.type + (this.referencedClass == null ? "?" : "") + (this.mayBeExtension ? "" : "=") + (this.mayBeNull ? "" : "!");
    }
}

