/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.model.MavenSource;

public class MavenGoalExecutionResult
implements Serializable {
    public final boolean success;
    @NotNull
    public final File file;
    @NotNull
    public final Folders folders;
    @NotNull
    public final Collection<MavenProjectProblem> problems;

    public MavenGoalExecutionResult(boolean success, @NotNull File file, @NotNull Folders folders, @NotNull Collection<MavenProjectProblem> problems) {
        if (file == null) {
            MavenGoalExecutionResult.$$$reportNull$$$0(0);
        }
        if (folders == null) {
            MavenGoalExecutionResult.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            MavenGoalExecutionResult.$$$reportNull$$$0(2);
        }
        this.success = success;
        this.file = file;
        this.folders = folders;
        this.problems = problems;
    }

    public String toString() {
        return "MavenGoalExecutionResult{success=" + this.success + ", file=" + this.file + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "folders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "problems";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/server/MavenGoalExecutionResult";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Folders
    implements Serializable {
        private List<MavenSource> myMavenSources = Collections.emptyList();

        public void setMavenSources(List<MavenSource> mavenSources) {
            this.myMavenSources = mavenSources;
        }

        public List<MavenSource> getMavenSources() {
            return this.myMavenSources;
        }

        public List<String> getSources() {
            return this.myMavenSources.stream().filter(it -> MavenSource.isSource(it)).map(it -> it.getDirectory()).collect(Collectors.toList());
        }

        public List<String> getTestSources() {
            return this.myMavenSources.stream().filter(it -> MavenSource.isTestSource(it)).map(it -> it.getDirectory()).collect(Collectors.toList());
        }

        public void set(List<String> sources, List<String> testSources, List<MavenResource> resources, List<MavenResource> testResources) {
            this.myMavenSources = new ArrayList<MavenSource>();
            sources.forEach(it -> this.myMavenSources.add(MavenSource.fromSrc(it, false)));
            testSources.forEach(it -> this.myMavenSources.add(MavenSource.fromSrc(it, true)));
            resources.forEach(it -> this.myMavenSources.add(MavenSource.fromResource(it, false)));
            testResources.forEach(it -> this.myMavenSources.add(MavenSource.fromResource(it, true)));
        }

        public List<MavenResource> getTestResources() {
            return this.myMavenSources.stream().filter(it -> MavenSource.isTestResource(it)).map(it -> new MavenResource((MavenSource)it)).collect(Collectors.toList());
        }

        public List<MavenResource> getResources() {
            return this.myMavenSources.stream().filter(it -> MavenSource.isResource(it)).map(it -> new MavenResource((MavenSource)it)).collect(Collectors.toList());
        }
    }
}

