/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Strings;

public class ShouldContainEntries
extends BasicErrorMessageFactory {
    public static <K, V> ErrorMessageFactory shouldContainEntries(Map<? extends K, ? extends V> actual, Map.Entry<? extends K, ? extends V>[] expectedEntries, Set<Map.Entry<? extends K, ? extends V>> entriesWithWrongValue, Set<Map.Entry<? extends K, ? extends V>> entriesWithKeyNotFound, Representation representation) {
        if (entriesWithWrongValue.isEmpty()) {
            return new ShouldContainEntries(actual, expectedEntries, entriesWithKeyNotFound);
        }
        if (entriesWithKeyNotFound.isEmpty()) {
            return new ShouldContainEntries(actual, expectedEntries, ShouldContainEntries.buildValueDifferences(actual, entriesWithWrongValue, representation));
        }
        return new ShouldContainEntries(actual, expectedEntries, entriesWithKeyNotFound, ShouldContainEntries.buildValueDifferences(actual, entriesWithWrongValue, representation));
    }

    private static <K, V> List<String> buildValueDifferences(Map<? extends K, ? extends V> actual, Set<Map.Entry<? extends K, ? extends V>> entriesWithWrongValues, Representation representation) {
        return entriesWithWrongValues.stream().map(entryWithWrongValue -> ShouldContainEntries.valueDifference(actual, entryWithWrongValue, representation)).collect(Collectors.toList());
    }

    private static <K, V> String valueDifference(Map<? extends K, ? extends V> actual, Map.Entry<? extends K, ? extends V> entryWithWrongValue, Representation representation) {
        K key = entryWithWrongValue.getKey();
        MapEntry<K, V> actualEntry = MapEntry.entry(key, actual.get(key));
        V expectedValue = entryWithWrongValue.getValue();
        return Strings.escapePercent("%s (expected: %s)".formatted(representation.toStringOf(actualEntry), representation.toStringOf(expectedValue)));
    }

    private <K, V> ShouldContainEntries(Map<? extends K, ? extends V> actual, Map.Entry<? extends K, ? extends V>[] expectedEntries, Set<Map.Entry<? extends K, ? extends V>> notFound) {
        super("%nExpecting map:%n  %s%nto contain entries:%n  %s%nbut could not find the following map entries:%n  %s", actual, expectedEntries, notFound);
    }

    private <K, V> ShouldContainEntries(Map<? extends K, ? extends V> actual, Map.Entry<? extends K, ? extends V>[] expectedEntries, List<String> valueDifferences) {
        super("%nExpecting map:%n  %s%nto contain entries:%n  %s%nbut the following map entries had different values:%n  " + String.valueOf(valueDifferences), actual, expectedEntries, valueDifferences);
    }

    private <K, V> ShouldContainEntries(Map<? extends K, ? extends V> actual, Map.Entry<? extends K, ? extends V>[] expectedEntries, Set<Map.Entry<? extends K, ? extends V>> keysNotFound, List<String> valueDifferences) {
        super("%nExpecting map:%n  %s%nto contain entries:%n  %s%nbut could not find the following map entries:%n  %s%nand the following map entries had different values:%n  " + String.valueOf(valueDifferences), actual, expectedEntries, keysNotFound);
    }
}

