/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.assertion;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionIntrospectionStrategy;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionNode;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class DefaultRecursiveAssertionIntrospectionStrategy
implements RecursiveAssertionIntrospectionStrategy {
    @Override
    public List<RecursiveAssertionNode> getChildNodesOf(Object node) {
        return Objects.getDeclaredFieldsIncludingInherited(node.getClass()).stream().map(field -> DefaultRecursiveAssertionIntrospectionStrategy.toNode(field, node)).collect(Collectors.toList());
    }

    @Override
    public String getDescription() {
        return "DefaultRecursiveAssertionIntrospectionStrategy which introspects all fields (including inherited ones)";
    }

    private static RecursiveAssertionNode toNode(Field field, Object node) {
        String fieldName = field.getName();
        Object fieldValue = PropertyOrFieldSupport.EXTRACTION.getSimpleValue(fieldName, node);
        Class<?> fieldType = DefaultRecursiveAssertionIntrospectionStrategy.getFieldType(fieldValue, fieldName, node);
        return new RecursiveAssertionNode(fieldValue, fieldName, fieldType);
    }

    private static Class<?> getFieldType(Object fieldValue, String fieldName, Object targetObject) {
        return fieldValue != null ? fieldValue.getClass() : DefaultRecursiveAssertionIntrospectionStrategy.getFieldType(fieldName, targetObject.getClass());
    }

    private static Class<?> getFieldType(String fieldName, Class<?> objectClass) {
        try {
            Optional<Field> potentialField = Arrays.stream(objectClass.getDeclaredFields()).filter(field -> fieldName.equals(field.getName())).findAny();
            if (potentialField.isPresent()) {
                return potentialField.get().getType();
            }
            Class<?> superclass = objectClass.getSuperclass();
            if (superclass != null) {
                return DefaultRecursiveAssertionIntrospectionStrategy.getFieldType(fieldName, superclass);
            }
            throw new NoSuchFieldException();
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("Could not find field %s on class %s, even though its name was retrieved from the class earlier".formatted(fieldName, objectClass.getCanonicalName()), e);
        }
    }
}

