/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.utils;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lai/grazie/nlp/utils/CharUtils;", "", "<init>", "()V", "controlChars", "", "Lkotlin/text/CharCategory;", "punctuationChars", "isPunctuation", "", "char", "", "isControl", "SOFT_HYPHEN", "getSOFT_HYPHEN", "()C", "nlp-common"})
public final class CharUtils {
    @NotNull
    public static final CharUtils INSTANCE = new CharUtils();
    @NotNull
    private static final Set<CharCategory> controlChars;
    @NotNull
    private static final Set<CharCategory> punctuationChars;
    private static final char SOFT_HYPHEN;

    private CharUtils() {
    }

    public final boolean isPunctuation(char c) {
        block5: {
            block4: {
                if (punctuationChars.contains(CharsKt.getCategory((char)c))) {
                    return true;
                }
                char c2 = c;
                if ('!' <= c2 ? c2 < '0' : false) break block4;
                c2 = c;
                if (':' <= c2 ? c2 < 'A' : false) break block4;
                c2 = c;
                if ('[' <= c2 ? c2 < 'a' : false) break block4;
                c2 = c;
                boolean bl = '{' <= c2 ? c2 < '\u007f' : false;
                if (!bl) break block5;
            }
            return true;
        }
        return false;
    }

    public final boolean isControl(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return false;
            }
        }
        return controlChars.contains(CharsKt.getCategory((char)c));
    }

    public final char getSOFT_HYPHEN() {
        return SOFT_HYPHEN;
    }

    static {
        Object[] objectArray = new CharCategory[]{CharCategory.UNASSIGNED, CharCategory.CONTROL, CharCategory.FORMAT, CharCategory.PRIVATE_USE, CharCategory.SURROGATE};
        controlChars = SetsKt.setOf((Object[])objectArray);
        objectArray = new CharCategory[]{CharCategory.DASH_PUNCTUATION, CharCategory.CONNECTOR_PUNCTUATION, CharCategory.END_PUNCTUATION, CharCategory.START_PUNCTUATION, CharCategory.OTHER_PUNCTUATION, CharCategory.INITIAL_QUOTE_PUNCTUATION, CharCategory.FINAL_QUOTE_PUNCTUATION};
        punctuationChars = SetsKt.setOf((Object[])objectArray);
        SOFT_HYPHEN = (char)173;
    }
}

