<?php

/**
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information please see
 * <http://phing.info>.
 */

namespace Phing\Test\Task\Optional;

use Phing\Task\Ext\SymfonyConsoleArg;
use PHPUnit\Framework\TestCase;

/**
 * Test class for Arg.
 * Generated by PHPUnit on 2012-02-13 at 12:02:17.
 *
 * @internal
 */
class ArgTest extends TestCase
{
    /**
     * @var SymfonyConsoleArg
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new SymfonyConsoleArg();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * @covers \SymfonyConsoleArg::getName
     * @covers \SymfonyConsoleArg::setName
     */
    public function testSetGetName(): void
    {
        $o = $this->object;
        $o->setName('foo');
        $this->assertEquals('foo', $o->getName());
    }

    /**
     * @covers \SymfonyConsoleArg::getValue
     * @covers \SymfonyConsoleArg::setValue
     */
    public function testSetGetValue(): void
    {
        $o = $this->object;
        $o->setValue('foo');
        $this->assertEquals('foo', $o->getValue());
    }

    /**
     * @covers \SymfonyConsoleArg::getQuotes
     * @covers \SymfonyConsoleArg::setQuotes
     */
    public function testGetQuotes(): void
    {
        $o = $this->object;
        $o->setQuotes(true);
        $this->assertEquals(true, $o->getQuotes());
    }

    /**
     * @covers \SymfonyConsoleArg::__toString
     */
    public function testToStringWithQuotes(): void
    {
        $o = $this->object;
        $o->setName('name');
        $o->setValue('value');
        $o->setQuotes(true);

        $this->assertEquals('--name="value"', '' . $o);
    }

    /**
     * @covers \SymfonyConsoleArg::__toString
     */
    public function testToStringWithoutQuotes(): void
    {
        $o = $this->object;
        $o->setName('name');
        $o->setValue('value');
        $o->setQuotes(false);

        $this->assertEquals('--name=value', '' . $o);
    }

    /**
     * @covers \SymfonyConsoleArg::__toString
     */
    public function testToStringJustName(): void
    {
        $o = $this->object;
        $o->setName('name');
        $o->setQuotes(false);

        $this->assertEquals('--name', '' . $o);
    }

    /**
     * @covers \SymfonyConsoleArg::__toString
     */
    public function testToStringJustValueWithoutQuotes(): void
    {
        $o = $this->object;
        $o->setValue('value');
        $o->setQuotes(false);

        $this->assertEquals('value', '' . $o);
    }

    /**
     * @covers \SymfonyConsoleArg::__toString
     */
    public function testToStringJustValueWithQuotes(): void
    {
        $o = $this->object;
        $o->setValue('value');
        $o->setQuotes(true);

        $this->assertEquals('"value"', '' . $o);
    }
}
