/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToFellerFormat
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        output.append("!\n!\tFile name: " + this.mTitle + ".BAS\n!\n");
        output.append("NAME=\"" + this.mTitle + "\"\n");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
        output.append("!\nEND\n");
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        output.append("!\n");
        int elementAtomicNumber = this.mPertable.atomicNumber(element);
        String elementName = this.mPertable.name(elementAtomicNumber);
        output.append("Z=" + elementAtomicNumber + "\t\t\t!\t" + elementName.toUpperCase() + "\n");
        String description = contractions.getChildText("description", BSEProperties.mDcNs);
        if (description.indexOf(" -> ") == -1) {
            output.append("DESCRIPTION=\"" + description.replaceFirst("->", " -> ") + "\"\n");
        } else {
            output.append("DESCRIPTION=\"" + description + "\"\n");
        }
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            if (shell.equalsIgnoreCase("sp")) {
                output.append("NUMEXP=" + rows + "\t\t" + shell.substring(0, 1) + "\t\t" + shell.substring(1) + "\n");
            } else {
                output.append("NUMEXP=" + rows + "\t\t" + shell + "\n");
            }
            try {
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        String value = this.formattedValue(matrix.getValue(i, j), j != 0);
                        output.append(value);
                    }
                    output.append("\n");
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }

    protected String formattedValue(String value, boolean bSpaceForSign) {
        int i;
        String[] split;
        String beforeDecimal;
        String tmp;
        int TOTAL_WIDTH = 17;
        int DECIMAL_WIDTH = 16;
        value = value.trim();
        boolean isExponential = false;
        String expChars = "DE";
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c = value.charAt(i2);
            if (c != 'D' && c != 'd' && c != 'E' && c != 'e') continue;
            isExponential = true;
        }
        if (!isExponential && value.indexOf(46) == -1) {
            value = value + ".0";
        }
        if ((tmp = (beforeDecimal = (split = value.split("\\."))[0].trim()).replaceAll("\\+", "").replaceAll("\\-", "")).trim().length() == 0) {
            value = beforeDecimal + "0" + value.substring(value.indexOf(46));
        }
        if (bSpaceForSign && beforeDecimal.indexOf(43) == -1 && beforeDecimal.indexOf(45) == -1) {
            value = " " + value;
        }
        beforeDecimal = value.split("\\.")[0];
        int nonDeciLen = beforeDecimal.length();
        int deciLen = value.length() - nonDeciLen;
        String whitespaces = "";
        for (i = 0; i < TOTAL_WIDTH - DECIMAL_WIDTH - nonDeciLen; ++i) {
            whitespaces = whitespaces + " ";
        }
        value = whitespaces + value;
        if (!isExponential && value.length() < 8 && value.length() < 8) {
            for (i = 0; i < 8 - value.length(); ++i) {
                value = value + "0";
            }
        }
        if (value.length() < TOTAL_WIDTH) {
            int fill = TOTAL_WIDTH - value.length();
            for (int i3 = 0; i3 < fill; ++i3) {
                value = value + " ";
            }
        } else {
            value = value + "      ";
        }
        return value;
    }
}

