// SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause
/* Copyright(c) 2024  Realtek Corporation
 */

#include "main.h"
#include "phy.h"
#include "rtw8812a_table.h"

static const u32 rtw8812a_mac[] = {
	0x010, 0x0000000C,
	0x80000200,	0x00000000,	0x40000000,	0x00000000,
	0x011, 0x00000066,
	0xA0000000,	0x00000000,
	0x011, 0x0000005A,
	0xB0000000,	0x00000000,
	0x025, 0x0000000F,
	0x072, 0x00000000,
	0x420, 0x00000080,
	0x428, 0x0000000A,
	0x429, 0x00000010,
	0x430, 0x00000000,
	0x431, 0x00000000,
	0x432, 0x00000000,
	0x433, 0x00000001,
	0x434, 0x00000002,
	0x435, 0x00000003,
	0x436, 0x00000005,
	0x437, 0x00000007,
	0x438, 0x00000000,
	0x439, 0x00000000,
	0x43A, 0x00000000,
	0x43B, 0x00000001,
	0x43C, 0x00000002,
	0x43D, 0x00000003,
	0x43E, 0x00000005,
	0x43F, 0x00000007,
	0x440, 0x0000005D,
	0x441, 0x00000001,
	0x442, 0x00000000,
	0x444, 0x00000010,
	0x445, 0x00000000,
	0x446, 0x00000000,
	0x447, 0x00000000,
	0x448, 0x00000000,
	0x449, 0x000000F0,
	0x44A, 0x0000000F,
	0x44B, 0x0000003E,
	0x44C, 0x00000010,
	0x44D, 0x00000000,
	0x44E, 0x00000000,
	0x44F, 0x00000000,
	0x450, 0x00000000,
	0x451, 0x000000F0,
	0x452, 0x0000000F,
	0x453, 0x00000000,
	0x45B, 0x00000080,
	0x460, 0x00000066,
	0x461, 0x00000066,
	0x4C8, 0x000000FF,
	0x4C9, 0x00000008,
	0x4CC, 0x000000FF,
	0x4CD, 0x000000FF,
	0x4CE, 0x00000001,
	0x500, 0x00000026,
	0x501, 0x000000A2,
	0x502, 0x0000002F,
	0x503, 0x00000000,
	0x504, 0x00000028,
	0x505, 0x000000A3,
	0x506, 0x0000005E,
	0x507, 0x00000000,
	0x508, 0x0000002B,
	0x509, 0x000000A4,
	0x50A, 0x0000005E,
	0x50B, 0x00000000,
	0x50C, 0x0000004F,
	0x50D, 0x000000A4,
	0x50E, 0x00000000,
	0x50F, 0x00000000,
	0x512, 0x0000001C,
	0x514, 0x0000000A,
	0x516, 0x0000000A,
	0x525, 0x0000004F,
	0x550, 0x00000010,
	0x551, 0x00000010,
	0x559, 0x00000002,
	0x55C, 0x00000050,
	0x55D, 0x000000FF,
	0x604, 0x00000009,
	0x605, 0x00000030,
	0x607, 0x00000003,
	0x608, 0x0000000E,
	0x609, 0x0000002A,
	0x620, 0x000000FF,
	0x621, 0x000000FF,
	0x622, 0x000000FF,
	0x623, 0x000000FF,
	0x624, 0x000000FF,
	0x625, 0x000000FF,
	0x626, 0x000000FF,
	0x627, 0x000000FF,
	0x638, 0x00000050,
	0x63C, 0x0000000A,
	0x63D, 0x0000000A,
	0x63E, 0x0000000E,
	0x63F, 0x0000000E,
	0x640, 0x00000080,
	0x642, 0x00000040,
	0x643, 0x00000000,
	0x652, 0x000000C8,
	0x66E, 0x00000005,
	0x700, 0x00000021,
	0x701, 0x00000043,
	0x702, 0x00000065,
	0x703, 0x00000087,
	0x708, 0x00000021,
	0x709, 0x00000043,
	0x70A, 0x00000065,
	0x70B, 0x00000087,
	0x718, 0x00000040,
};

RTW_DECL_TABLE_PHY_COND(rtw8812a_mac, rtw_phy_cfg_mac);

static const u32 rtw8812a_agc[] = {
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFC000001,
	0x81C, 0xFB020001,
	0x81C, 0xFA040001,
	0x81C, 0xF9060001,
	0x81C, 0xF8080001,
	0x81C, 0xF70A0001,
	0x81C, 0xF60C0001,
	0x81C, 0xF50E0001,
	0x81C, 0xF4100001,
	0x81C, 0xF3120001,
	0x81C, 0xF2140001,
	0x81C, 0xF1160001,
	0x81C, 0xF0180001,
	0x81C, 0xEF1A0001,
	0x81C, 0xEE1C0001,
	0x81C, 0xED1E0001,
	0x81C, 0xEC200001,
	0x81C, 0xEB220001,
	0x81C, 0xEA240001,
	0x81C, 0xCD260001,
	0x81C, 0xCC280001,
	0x81C, 0xCB2A0001,
	0x81C, 0xCA2C0001,
	0x81C, 0xC92E0001,
	0x81C, 0xC8300001,
	0x81C, 0xA6320001,
	0x81C, 0xA5340001,
	0x81C, 0xA4360001,
	0x81C, 0xA3380001,
	0x81C, 0xA23A0001,
	0x81C, 0x883C0001,
	0x81C, 0x873E0001,
	0x81C, 0x86400001,
	0x81C, 0x85420001,
	0x81C, 0x84440001,
	0x81C, 0x83460001,
	0x81C, 0x82480001,
	0x81C, 0x814A0001,
	0x81C, 0x484C0001,
	0x81C, 0x474E0001,
	0x81C, 0x46500001,
	0x81C, 0x45520001,
	0x81C, 0x44540001,
	0x81C, 0x43560001,
	0x81C, 0x42580001,
	0x81C, 0x415A0001,
	0x81C, 0x255C0001,
	0x81C, 0x245E0001,
	0x81C, 0x23600001,
	0x81C, 0x22620001,
	0x81C, 0x21640001,
	0x81C, 0x21660001,
	0x81C, 0x21680001,
	0x81C, 0x216A0001,
	0x81C, 0x216C0001,
	0x81C, 0x216E0001,
	0x81C, 0x21700001,
	0x81C, 0x21720001,
	0x81C, 0x21740001,
	0x81C, 0x21760001,
	0x81C, 0x21780001,
	0x81C, 0x217A0001,
	0x81C, 0x217C0001,
	0x81C, 0x217E0001,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
	0x81C, 0xF9000001,
	0x81C, 0xF8020001,
	0x81C, 0xF7040001,
	0x81C, 0xF6060001,
	0x81C, 0xF5080001,
	0x81C, 0xF40A0001,
	0x81C, 0xF30C0001,
	0x81C, 0xF20E0001,
	0x81C, 0xF1100001,
	0x81C, 0xF0120001,
	0x81C, 0xEF140001,
	0x81C, 0xEE160001,
	0x81C, 0xED180001,
	0x81C, 0xEC1A0001,
	0x81C, 0xEB1C0001,
	0x81C, 0xEA1E0001,
	0x81C, 0xCD200001,
	0x81C, 0xCC220001,
	0x81C, 0xCB240001,
	0x81C, 0xCA260001,
	0x81C, 0xC9280001,
	0x81C, 0xC82A0001,
	0x81C, 0xC72C0001,
	0x81C, 0xC62E0001,
	0x81C, 0xA5300001,
	0x81C, 0xA4320001,
	0x81C, 0xA3340001,
	0x81C, 0xA2360001,
	0x81C, 0x88380001,
	0x81C, 0x873A0001,
	0x81C, 0x863C0001,
	0x81C, 0x853E0001,
	0x81C, 0x84400001,
	0x81C, 0x83420001,
	0x81C, 0x82440001,
	0x81C, 0x81460001,
	0x81C, 0x48480001,
	0x81C, 0x474A0001,
	0x81C, 0x464C0001,
	0x81C, 0x454E0001,
	0x81C, 0x44500001,
	0x81C, 0x43520001,
	0x81C, 0x42540001,
	0x81C, 0x41560001,
	0x81C, 0x25580001,
	0x81C, 0x245A0001,
	0x81C, 0x235C0001,
	0x81C, 0x225E0001,
	0x81C, 0x21600001,
	0x81C, 0x21620001,
	0x81C, 0x21640001,
	0x81C, 0x21660001,
	0x81C, 0x21680001,
	0x81C, 0x216A0001,
	0x81C, 0x236C0001,
	0x81C, 0x226E0001,
	0x81C, 0x21700001,
	0x81C, 0x21720001,
	0x81C, 0x21740001,
	0x81C, 0x21760001,
	0x81C, 0x21780001,
	0x81C, 0x217A0001,
	0x81C, 0x217C0001,
	0x81C, 0x217E0001,
	0xA0000000,	0x00000000,
	0x81C, 0xFF000001,
	0x81C, 0xFF020001,
	0x81C, 0xFF040001,
	0x81C, 0xFF060001,
	0x81C, 0xFF080001,
	0x81C, 0xFE0A0001,
	0x81C, 0xFD0C0001,
	0x81C, 0xFC0E0001,
	0x81C, 0xFB100001,
	0x81C, 0xFA120001,
	0x81C, 0xF9140001,
	0x81C, 0xF8160001,
	0x81C, 0xF7180001,
	0x81C, 0xF61A0001,
	0x81C, 0xF51C0001,
	0x81C, 0xF41E0001,
	0x81C, 0xF3200001,
	0x81C, 0xF2220001,
	0x81C, 0xF1240001,
	0x81C, 0xF0260001,
	0x81C, 0xEF280001,
	0x81C, 0xEE2A0001,
	0x81C, 0xED2C0001,
	0x81C, 0xEC2E0001,
	0x81C, 0xEB300001,
	0x81C, 0xEA320001,
	0x81C, 0xE9340001,
	0x81C, 0xE8360001,
	0x81C, 0xE7380001,
	0x81C, 0xE63A0001,
	0x81C, 0xE53C0001,
	0x81C, 0xC73E0001,
	0x81C, 0xC6400001,
	0x81C, 0xC5420001,
	0x81C, 0xC4440001,
	0x81C, 0xC3460001,
	0x81C, 0xC2480001,
	0x81C, 0xC14A0001,
	0x81C, 0xA74C0001,
	0x81C, 0xA64E0001,
	0x81C, 0xA5500001,
	0x81C, 0xA4520001,
	0x81C, 0xA3540001,
	0x81C, 0xA2560001,
	0x81C, 0xA1580001,
	0x81C, 0x675A0001,
	0x81C, 0x665C0001,
	0x81C, 0x655E0001,
	0x81C, 0x64600001,
	0x81C, 0x63620001,
	0x81C, 0x48640001,
	0x81C, 0x47660001,
	0x81C, 0x46680001,
	0x81C, 0x456A0001,
	0x81C, 0x446C0001,
	0x81C, 0x436E0001,
	0x81C, 0x42700001,
	0x81C, 0x41720001,
	0x81C, 0x41740001,
	0x81C, 0x41760001,
	0x81C, 0x41780001,
	0x81C, 0x417A0001,
	0x81C, 0x417C0001,
	0x81C, 0x417E0001,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0xFC800001,
	0x81C, 0xFB820001,
	0x81C, 0xFA840001,
	0x81C, 0xF9860001,
	0x81C, 0xF8880001,
	0x81C, 0xF78A0001,
	0x81C, 0xF68C0001,
	0x81C, 0xF58E0001,
	0x81C, 0xF4900001,
	0x81C, 0xF3920001,
	0x81C, 0xF2940001,
	0x81C, 0xF1960001,
	0x81C, 0xF0980001,
	0x81C, 0xEF9A0001,
	0x81C, 0xEE9C0001,
	0x81C, 0xED9E0001,
	0x81C, 0xECA00001,
	0x81C, 0xEBA20001,
	0x81C, 0xEAA40001,
	0x81C, 0xE9A60001,
	0x81C, 0xE8A80001,
	0x81C, 0xE7AA0001,
	0x81C, 0xE6AC0001,
	0x81C, 0xE5AE0001,
	0x81C, 0xE4B00001,
	0x81C, 0xE3B20001,
	0x81C, 0xA8B40001,
	0x81C, 0xA7B60001,
	0x81C, 0xA6B80001,
	0x81C, 0xA5BA0001,
	0x81C, 0xA4BC0001,
	0x81C, 0xA3BE0001,
	0x81C, 0xA2C00001,
	0x81C, 0xA1C20001,
	0x81C, 0x68C40001,
	0x81C, 0x67C60001,
	0x81C, 0x66C80001,
	0x81C, 0x65CA0001,
	0x81C, 0x64CC0001,
	0x81C, 0x47CE0001,
	0x81C, 0x46D00001,
	0x81C, 0x45D20001,
	0x81C, 0x44D40001,
	0x81C, 0x43D60001,
	0x81C, 0x42D80001,
	0x81C, 0x08DA0001,
	0x81C, 0x07DC0001,
	0x81C, 0x06DE0001,
	0x81C, 0x05E00001,
	0x81C, 0x04E20001,
	0x81C, 0x03E40001,
	0x81C, 0x02E60001,
	0x81C, 0x01E80001,
	0x81C, 0x01EA0001,
	0x81C, 0x01EC0001,
	0x81C, 0x01EE0001,
	0x81C, 0x01F00001,
	0x81C, 0x01F20001,
	0x81C, 0x01F40001,
	0x81C, 0x01F60001,
	0x81C, 0x01F80001,
	0x81C, 0x01FA0001,
	0x81C, 0x01FC0001,
	0x81C, 0x01FE0001,
	0xA0000000,	0x00000000,
	0x81C, 0xFF800001,
	0x81C, 0xFF820001,
	0x81C, 0xFF840001,
	0x81C, 0xFE860001,
	0x81C, 0xFD880001,
	0x81C, 0xFC8A0001,
	0x81C, 0xFB8C0001,
	0x81C, 0xFA8E0001,
	0x81C, 0xF9900001,
	0x81C, 0xF8920001,
	0x81C, 0xF7940001,
	0x81C, 0xF6960001,
	0x81C, 0xF5980001,
	0x81C, 0xF49A0001,
	0x81C, 0xF39C0001,
	0x81C, 0xF29E0001,
	0x81C, 0xF1A00001,
	0x81C, 0xF0A20001,
	0x81C, 0xEFA40001,
	0x81C, 0xEEA60001,
	0x81C, 0xEDA80001,
	0x81C, 0xECAA0001,
	0x81C, 0xEBAC0001,
	0x81C, 0xEAAE0001,
	0x81C, 0xE9B00001,
	0x81C, 0xE8B20001,
	0x81C, 0xE7B40001,
	0x81C, 0xE6B60001,
	0x81C, 0xE5B80001,
	0x81C, 0xE4BA0001,
	0x81C, 0xE3BC0001,
	0x81C, 0xA8BE0001,
	0x81C, 0xA7C00001,
	0x81C, 0xA6C20001,
	0x81C, 0xA5C40001,
	0x81C, 0xA4C60001,
	0x81C, 0xA3C80001,
	0x81C, 0xA2CA0001,
	0x81C, 0xA1CC0001,
	0x81C, 0x68CE0001,
	0x81C, 0x67D00001,
	0x81C, 0x66D20001,
	0x81C, 0x65D40001,
	0x81C, 0x64D60001,
	0x81C, 0x47D80001,
	0x81C, 0x46DA0001,
	0x81C, 0x45DC0001,
	0x81C, 0x44DE0001,
	0x81C, 0x43E00001,
	0x81C, 0x42E20001,
	0x81C, 0x08E40001,
	0x81C, 0x07E60001,
	0x81C, 0x06E80001,
	0x81C, 0x05EA0001,
	0x81C, 0x04EC0001,
	0x81C, 0x03EE0001,
	0x81C, 0x02F00001,
	0x81C, 0x01F20001,
	0x81C, 0x01F40001,
	0x81C, 0x01F60001,
	0x81C, 0x01F80001,
	0x81C, 0x01FA0001,
	0x81C, 0x01FC0001,
	0x81C, 0x01FE0001,
	0xB0000000,	0x00000000,
	0xC50, 0x00000022,
	0xC50, 0x00000020,
	0xE50, 0x00000022,
	0xE50, 0x00000020,
};

RTW_DECL_TABLE_PHY_COND(rtw8812a_agc, rtw_phy_cfg_agc);

static const u32 rtw8812a_agc_diff_lb[] = {
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0x47CE0001,
	0x81C, 0x46D00001,
	0x81C, 0x45D20001,
	0x81C, 0x44D40001,
	0x81C, 0x43D60001,
	0x81C, 0x42D80001,
	0x81C, 0x08DA0001,
	0x81C, 0x07DC0001,
	0x81C, 0x06DE0001,
	0x81C, 0x05E00001,
	0x81C, 0x04E20001,
	0x81C, 0x03E40001,
	0x81C, 0x02E60001,
	0xA0000000,	0x00000000,
	0x81C, 0x47D80001,
	0x81C, 0x46DA0001,
	0x81C, 0x45DC0001,
	0x81C, 0x44DE0001,
	0x81C, 0x43E00001,
	0x81C, 0x42E20001,
	0x81C, 0x08E40001,
	0x81C, 0x07E60001,
	0x81C, 0x06E80001,
	0x81C, 0x05EA0001,
	0x81C, 0x04EC0001,
	0x81C, 0x03EE0001,
	0x81C, 0x02F00001,
	0xB0000000,	0x00000000,
};

RTW_DECL_TABLE_PHY_COND(rtw8812a_agc_diff_lb, rtw_phy_cfg_agc);

static const u32 rtw8812a_agc_diff_hb[] = {
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x81C, 0x45CE0001,
	0x81C, 0x44D00001,
	0x81C, 0x43D20001,
	0x81C, 0x42D40001,
	0x81C, 0x08D60001,
	0x81C, 0x07D80001,
	0x81C, 0x06DA0001,
	0x81C, 0x05DC0001,
	0x81C, 0x04DE0001,
	0x81C, 0x03E00001,
	0x81C, 0x02E20001,
	0x81C, 0x01E40001,
	0x81C, 0x01E60001,
	0xA0000000,	0x00000000,
	0x81C, 0x45D80001,
	0x81C, 0x44DA0001,
	0x81C, 0x43DC0001,
	0x81C, 0x42DE0001,
	0x81C, 0x08E00001,
	0x81C, 0x07E20001,
	0x81C, 0x06E40001,
	0x81C, 0x05E60001,
	0x81C, 0x04E80001,
	0x81C, 0x03EA0001,
	0x81C, 0x02EC0001,
	0x81C, 0x01EE0001,
	0x81C, 0x01F00001,
	0xB0000000,	0x00000000,
};

RTW_DECL_TABLE_PHY_COND(rtw8812a_agc_diff_hb, rtw_phy_cfg_agc);

static const u32 rtw8812a_bb[] = {
	0x800, 0x8020D010,
	0x804, 0x080112E0,
	0x808, 0x0E028233,
	0x80C, 0x12131113,
	0x810, 0x20101263,
	0x814, 0x020C3D10,
	0x818, 0x03A00385,
	0x820, 0x00000000,
	0x824, 0x00030FE0,
	0x828, 0x00000000,
	0x82C, 0x002083DD,
	0x830, 0x2EAAEEB8,
	0x834, 0x0037A706,
	0x838, 0x06C89B44,
	0x83C, 0x0000095B,
	0x840, 0xC0000001,
	0x844, 0x40003CDE,
	0x848, 0x6210FF8B,
	0x84C, 0x6CFDFFB8,
	0x850, 0x28874706,
	0x854, 0x0001520C,
	0x858, 0x8060E000,
	0x85C, 0x74210168,
	0x860, 0x6929C321,
	0x864, 0x79727432,
	0x868, 0x8CA7A314,
	0x86C, 0x338C2878,
	0x870, 0x03333333,
	0x874, 0x31602C2E,
	0x878, 0x00003152,
	0x87C, 0x000FC000,
	0x8A0, 0x00000013,
	0x8A4, 0x7F7F7F7F,
	0x8A8, 0xA202033E,
	0x8AC, 0x0FF0FA0A,
	0x8B0, 0x00000600,
	0x8B4, 0x000FC080,
	0x8B8, 0x6C10D7FF,
	0x8BC, 0x4CA520A3,
	0x8C0, 0x27F00020,
	0x8C4, 0x00000000,
	0x8C8, 0x00012D69,
	0x8CC, 0x08248492,
	0x8D0, 0x0000B800,
	0x8DC, 0x00000000,
	0x8D4, 0x940008A0,
	0x8D8, 0x290B5612,
	0x8F8, 0x400002C0,
	0x8FC, 0x00000000,
	0x900, 0x00000701,
	0x90C, 0x00000000,
	0x910, 0x0000FC00,
	0x914, 0x00000404,
	0x918, 0x1C1028C0,
	0x91C, 0x64B11A1C,
	0x920, 0xE0767233,
	0x924, 0x055AA500,
	0x928, 0x00000004,
	0x92C, 0xFFFE0000,
	0x930, 0xFFFFFFFE,
	0x934, 0x001FFFFF,
	0x960, 0x00000000,
	0x964, 0x00000000,
	0x968, 0x00000000,
	0x96C, 0x00000000,
	0x970, 0x801FFFFF,
	0x978, 0x00000000,
	0x97C, 0x00000000,
	0x980, 0x00000000,
	0x984, 0x00000000,
	0x988, 0x00000000,
	0x990, 0x27100000,
	0x994, 0xFFFF0100,
	0x998, 0xFFFFFF5C,
	0x99C, 0xFFFFFFFF,
	0x9A0, 0x000000FF,
	0x9A4, 0x00080080,
	0x9A8, 0x00000000,
	0x9AC, 0x00000000,
	0x9B0, 0x81081008,
	0x9B4, 0x00000000,
	0x9B8, 0x01081008,
	0x9BC, 0x01081008,
	0x9D0, 0x00000000,
	0x9D4, 0x00000000,
	0x9D8, 0x00000000,
	0x9DC, 0x00000000,
	0x9E4, 0x00000003,
	0x9E8, 0x000002D5,
	0xA00, 0x00D047C8,
	0xA04, 0x01FF000C,
	0xA08, 0x8C838300,
	0xA0C, 0x2E7F000F,
	0xA10, 0x9500BB78,
	0xA14, 0x11144028,
	0xA18, 0x00881117,
	0xA1C, 0x89140F00,
	0xA20, 0x1A1B0000,
	0xA24, 0x090E1217,
	0xA28, 0x00000305,
	0xA2C, 0x00900000,
	0xA70, 0x101FFF00,
	0xA74, 0x00000008,
	0xA78, 0x00000900,
	0xA7C, 0x225B0606,
	0xA80, 0x218075B2,
	0xA84, 0x001F8C80,
	0xB00, 0x03100000,
	0xB04, 0x0000B000,
	0xB08, 0xAE0201EB,
	0xB0C, 0x01003207,
	0xB10, 0x00009807,
	0xB14, 0x01000000,
	0xB18, 0x00000002,
	0xB1C, 0x00000002,
	0xB20, 0x0000001F,
	0xB24, 0x03020100,
	0xB28, 0x07060504,
	0xB2C, 0x0B0A0908,
	0xB30, 0x0F0E0D0C,
	0xB34, 0x13121110,
	0xB38, 0x17161514,
	0xB3C, 0x0000003A,
	0xB40, 0x00000000,
	0xB44, 0x00000000,
	0xB48, 0x13000032,
	0xB4C, 0x48080000,
	0xB50, 0x00000000,
	0xB54, 0x00000000,
	0xB58, 0x00000000,
	0xB5C, 0x00000000,
	0xC00, 0x00000007,
	0xC04, 0x00042020,
	0xC08, 0x80410231,
	0xC0C, 0x00000000,
	0xC10, 0x00000100,
	0xC14, 0x01000000,
	0xC1C, 0x40000003,
	0xC20, 0x12121212,
	0xC24, 0x12121212,
	0xC28, 0x12121212,
	0xC2C, 0x12121212,
	0xC30, 0x12121212,
	0xC34, 0x12121212,
	0xC38, 0x12121212,
	0xC3C, 0x12121212,
	0xC40, 0x12121212,
	0xC44, 0x12121212,
	0xC48, 0x12121212,
	0xC4C, 0x12121212,
	0xC50, 0x00000020,
	0xC54, 0x0008121C,
	0xC58, 0x30000C1C,
	0xC5C, 0x00000058,
	0xC60, 0x34344443,
	0xC64, 0x07003333,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0xC68, 0x59791979,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0xC68, 0x59791979,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0xC68, 0x59791979,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
	0xC68, 0x59791979,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
	0xC68, 0x59791979,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
	0xC68, 0x59791979,
	0xA0000000,	0x00000000,
	0xC68, 0x59799979,
	0xB0000000,	0x00000000,
	0xC6C, 0x59795979,
	0xC70, 0x19795979,
	0xC74, 0x19795979,
	0xC78, 0x19791979,
	0xC7C, 0x19791979,
	0xC80, 0x19791979,
	0xC84, 0x19791979,
	0xC94, 0x0100005C,
	0xC98, 0x00000000,
	0xC9C, 0x00000000,
	0xCA0, 0x00000029,
	0xCA4, 0x08040201,
	0xCA8, 0x80402010,
	0xCB0, 0x77547777,
	0xCB4, 0x00000077,
	0xCB8, 0x00508242,
	0xE00, 0x00000007,
	0xE04, 0x00042020,
	0xE08, 0x80410231,
	0xE0C, 0x00000000,
	0xE10, 0x00000100,
	0xE14, 0x01000000,
	0xE1C, 0x40000003,
	0xE20, 0x12121212,
	0xE24, 0x12121212,
	0xE28, 0x12121212,
	0xE2C, 0x12121212,
	0xE30, 0x12121212,
	0xE34, 0x12121212,
	0xE38, 0x12121212,
	0xE3C, 0x12121212,
	0xE40, 0x12121212,
	0xE44, 0x12121212,
	0xE48, 0x12121212,
	0xE4C, 0x12121212,
	0xE50, 0x00000020,
	0xE54, 0x0008121C,
	0xE58, 0x30000C1C,
	0xE5C, 0x00000058,
	0xE60, 0x34344443,
	0xE64, 0x07003333,
	0xE68, 0x59791979,
	0xE6C, 0x59795979,
	0xE70, 0x19795979,
	0xE74, 0x19795979,
	0xE78, 0x19791979,
	0xE7C, 0x19791979,
	0xE80, 0x19791979,
	0xE84, 0x19791979,
	0xE94, 0x0100005C,
	0xE98, 0x00000000,
	0xE9C, 0x00000000,
	0xEA0, 0x00000029,
	0xEA4, 0x08040201,
	0xEA8, 0x80402010,
	0xEB0, 0x77547777,
	0xEB4, 0x00000077,
	0xEB8, 0x00508242,
};

RTW_DECL_TABLE_PHY_COND(rtw8812a_bb, rtw_phy_cfg_bb);

static const struct rtw_phy_pg_cfg_pair rtw8812a_bb_pg[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x34363840, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x42424444, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x30323638, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x40424444, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x28303236, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x38404242, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x26283034, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x40424444, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x28303236, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x42422426, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x30343840, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x34363840, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x42424444, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x30323638, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x40424444, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x28303236, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x38404242, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x26283034, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x40424444, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x28303236, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x42422426, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x30343840, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x42424444, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x30323640, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x40424444, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x28303236, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x38404242, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x26283034, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x40424444, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x28303236, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x42422426, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x30343840, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x42424444, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x30323640, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x40424444, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x28303236, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x38404242, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x26283034, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x40424444, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x28303236, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x42422426, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x30343840, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628, },
};

RTW_DECL_TABLE_BB_PG(rtw8812a_bb_pg);

static const struct rtw_phy_pg_cfg_pair rtw8812a_bb_pg_rfe3[] = {
	{ 0, 0, 0, 0x00000c20, 0xffffffff, 0x34343434, },
	{ 0, 0, 0, 0x00000c24, 0xffffffff, 0x32323232, },
	{ 0, 0, 0, 0x00000c28, 0xffffffff, 0x28303232, },
	{ 0, 0, 0, 0x00000c2c, 0xffffffff, 0x32323232, },
	{ 0, 0, 0, 0x00000c30, 0xffffffff, 0x28303232, },
	{ 0, 0, 1, 0x00000c34, 0xffffffff, 0x32323232, },
	{ 0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032, },
	{ 0, 0, 0, 0x00000c3c, 0xffffffff, 0x32323232, },
	{ 0, 0, 0, 0x00000c40, 0xffffffff, 0x28303232, },
	{ 0, 0, 0, 0x00000c44, 0xffffffff, 0x32322426, },
	{ 0, 0, 1, 0x00000c48, 0xffffffff, 0x32323232, },
	{ 0, 0, 1, 0x00000c4c, 0xffffffff, 0x24262830, },
	{ 0, 1, 0, 0x00000e20, 0xffffffff, 0x34343434, },
	{ 0, 1, 0, 0x00000e24, 0xffffffff, 0x32323232, },
	{ 0, 1, 0, 0x00000e28, 0xffffffff, 0x28303232, },
	{ 0, 1, 0, 0x00000e2c, 0xffffffff, 0x32323232, },
	{ 0, 1, 0, 0x00000e30, 0xffffffff, 0x28303232, },
	{ 0, 1, 1, 0x00000e34, 0xffffffff, 0x32323232, },
	{ 0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032, },
	{ 0, 1, 0, 0x00000e3c, 0xffffffff, 0x32323232, },
	{ 0, 1, 0, 0x00000e40, 0xffffffff, 0x28303232, },
	{ 0, 1, 0, 0x00000e44, 0xffffffff, 0x32322426, },
	{ 0, 1, 1, 0x00000e48, 0xffffffff, 0x32323232, },
	{ 0, 1, 1, 0x00000e4c, 0xffffffff, 0x24262830, },
	{ 1, 0, 0, 0x00000c24, 0xffffffff, 0x32323232, },
	{ 1, 0, 0, 0x00000c28, 0xffffffff, 0x28303232, },
	{ 1, 0, 0, 0x00000c2c, 0xffffffff, 0x32323232, },
	{ 1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830, },
	{ 1, 0, 1, 0x00000c34, 0xffffffff, 0x32323232, },
	{ 1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830, },
	{ 1, 0, 0, 0x00000c3c, 0xffffffff, 0x32323232, },
	{ 1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830, },
	{ 1, 0, 0, 0x00000c44, 0xffffffff, 0x32322222, },
	{ 1, 0, 1, 0x00000c48, 0xffffffff, 0x28303232, },
	{ 1, 0, 1, 0x00000c4c, 0xffffffff, 0x22222426, },
	{ 1, 1, 0, 0x00000e24, 0xffffffff, 0x32323232, },
	{ 1, 1, 0, 0x00000e28, 0xffffffff, 0x28303232, },
	{ 1, 1, 0, 0x00000e2c, 0xffffffff, 0x32323232, },
	{ 1, 1, 0, 0x00000e30, 0xffffffff, 0x24262830, },
	{ 1, 1, 1, 0x00000e34, 0xffffffff, 0x32323232, },
	{ 1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830, },
	{ 1, 1, 0, 0x00000e3c, 0xffffffff, 0x32323232, },
	{ 1, 1, 0, 0x00000e40, 0xffffffff, 0x24262830, },
	{ 1, 1, 0, 0x00000e44, 0xffffffff, 0x32322222, },
	{ 1, 1, 1, 0x00000e48, 0xffffffff, 0x28303232, },
	{ 1, 1, 1, 0x00000e4c, 0xffffffff, 0x22222426, },
};

RTW_DECL_TABLE_BB_PG(rtw8812a_bb_pg_rfe3);

static const u32 rtw8812a_rf_a[] = {
	0x000, 0x00010000,
	0x018, 0x0001712A,
	0x056, 0x00051CF2,
	0x066, 0x00040000,
	0x01E, 0x00080000,
	0x089, 0x00000080,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x086, 0x00014B3A,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
	0x086, 0x00014B3A,
	0xA0000000,	0x00000000,
	0x086, 0x00014B38,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x08B, 0x00080180,
	0xA0000000,	0x00000000,
	0x08B, 0x00087180,
	0xB0000000,	0x00000000,
	0x0B1, 0x0001FC1A,
	0x0B3, 0x000F0810,
	0x0B4, 0x0001A78D,
	0x0BA, 0x00086180,
	0x018, 0x00000006,
	0x0EF, 0x00002000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x03B, 0x0003F218,
	0x03B, 0x00030A58,
	0x03B, 0x0002FA58,
	0x03B, 0x00022590,
	0x03B, 0x0001FA50,
	0x03B, 0x00010248,
	0x03B, 0x00008240,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
	0x03B, 0x0003F218,
	0x03B, 0x00030A58,
	0x03B, 0x0002FA58,
	0x03B, 0x00022590,
	0x03B, 0x0001FA50,
	0x03B, 0x00010248,
	0x03B, 0x00008240,
	0xA0000000,	0x00000000,
	0x03B, 0x00038A58,
	0x03B, 0x00037A58,
	0x03B, 0x0002A590,
	0x03B, 0x00027A50,
	0x03B, 0x00018248,
	0x03B, 0x00010240,
	0x03B, 0x00008240,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000100,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000A4EE,
	0x034, 0x00009076,
	0x034, 0x00008073,
	0x034, 0x00007070,
	0x034, 0x0000606D,
	0x034, 0x0000506A,
	0x034, 0x00004049,
	0x034, 0x00003046,
	0x034, 0x00002028,
	0x034, 0x00001025,
	0x034, 0x00000022,
	0xA0000000,	0x00000000,
	0x034, 0x0000ADF4,
	0x034, 0x00009DF1,
	0x034, 0x00008DEE,
	0x034, 0x00007DEB,
	0x034, 0x00006DE8,
	0x034, 0x00005DE5,
	0x034, 0x00004DE2,
	0x034, 0x00003CE6,
	0x034, 0x000024E7,
	0x034, 0x000014E4,
	0x034, 0x000004E1,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x0EF, 0x000020A2,
	0x0DF, 0x00000080,
	0x035, 0x00000192,
	0x035, 0x00008192,
	0x035, 0x00010192,
	0x036, 0x00000024,
	0x036, 0x00008024,
	0x036, 0x00010024,
	0x036, 0x00018024,
	0x0EF, 0x00000000,
	0x051, 0x00000C21,
	0x052, 0x000006D9,
	0x053, 0x000FC649,
	0x054, 0x0000017E,
	0x0EF, 0x00000002,
	0x008, 0x00008400,
	0x018, 0x0001712A,
	0x0EF, 0x00001000,
	0x03A, 0x00000080,
	0x03B, 0x0003A02C,
	0x03C, 0x00004000,
	0x03A, 0x00000400,
	0x03B, 0x0003202C,
	0x03C, 0x00010000,
	0x03A, 0x000000A0,
	0x03B, 0x0002B064,
	0x03C, 0x00004000,
	0x03A, 0x000000D8,
	0x03B, 0x00023070,
	0x03C, 0x00004000,
	0x03A, 0x00000468,
	0x03B, 0x0001B870,
	0x03C, 0x00010000,
	0x03A, 0x00000098,
	0x03B, 0x00012085,
	0x03C, 0x000E4000,
	0x03A, 0x00000418,
	0x03B, 0x0000A080,
	0x03C, 0x000F0000,
	0x03A, 0x00000418,
	0x03B, 0x00002080,
	0x03C, 0x00010000,
	0x03A, 0x00000080,
	0x03B, 0x0007A02C,
	0x03C, 0x00004000,
	0x03A, 0x00000400,
	0x03B, 0x0007202C,
	0x03C, 0x00010000,
	0x03A, 0x000000A0,
	0x03B, 0x0006B064,
	0x03C, 0x00004000,
	0x03A, 0x000000D8,
	0x03B, 0x00063070,
	0x03C, 0x00004000,
	0x03A, 0x00000468,
	0x03B, 0x0005B870,
	0x03C, 0x00010000,
	0x03A, 0x00000098,
	0x03B, 0x00052085,
	0x03C, 0x000E4000,
	0x03A, 0x00000418,
	0x03B, 0x0004A080,
	0x03C, 0x000F0000,
	0x03A, 0x00000418,
	0x03B, 0x00042080,
	0x03C, 0x00010000,
	0x03A, 0x00000080,
	0x03B, 0x000BA02C,
	0x03C, 0x00004000,
	0x03A, 0x00000400,
	0x03B, 0x000B202C,
	0x03C, 0x00010000,
	0x03A, 0x000000A0,
	0x03B, 0x000AB064,
	0x03C, 0x00004000,
	0x03A, 0x000000D8,
	0x03B, 0x000A3070,
	0x03C, 0x00004000,
	0x03A, 0x00000468,
	0x03B, 0x0009B870,
	0x03C, 0x00010000,
	0x03A, 0x00000098,
	0x03B, 0x00092085,
	0x03C, 0x000E4000,
	0x03A, 0x00000418,
	0x03B, 0x0008A080,
	0x03C, 0x000F0000,
	0x03A, 0x00000418,
	0x03B, 0x00082080,
	0x03C, 0x00010000,
	0x0EF, 0x00001100,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004A0B2,
	0x034, 0x000490AF,
	0x034, 0x00048070,
	0x034, 0x0004706D,
	0x034, 0x00046050,
	0x034, 0x0004504D,
	0x034, 0x0004404A,
	0x034, 0x00043047,
	0x034, 0x0004200A,
	0x034, 0x00041007,
	0x034, 0x00040004,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x034, 0x0004A0B2,
	0x034, 0x000490AF,
	0x034, 0x00048070,
	0x034, 0x0004706D,
	0x034, 0x0004604D,
	0x034, 0x0004504A,
	0x034, 0x00044047,
	0x034, 0x00043044,
	0x034, 0x00042007,
	0x034, 0x00041004,
	0x034, 0x00040001,
	0xA0000000,	0x00000000,
	0x034, 0x0004ADF5,
	0x034, 0x00049DF2,
	0x034, 0x00048DEF,
	0x034, 0x00047DEC,
	0x034, 0x00046DE9,
	0x034, 0x00045DE6,
	0x034, 0x00044DE3,
	0x034, 0x000438C8,
	0x034, 0x000428C5,
	0x034, 0x000418C2,
	0x034, 0x000408C0,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0002A0B2,
	0x034, 0x000290AF,
	0x034, 0x00028070,
	0x034, 0x0002706D,
	0x034, 0x00026050,
	0x034, 0x0002504D,
	0x034, 0x0002404A,
	0x034, 0x00023047,
	0x034, 0x0002200A,
	0x034, 0x00021007,
	0x034, 0x00020004,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x034, 0x0002A0B4,
	0x034, 0x000290B1,
	0x034, 0x00028072,
	0x034, 0x0002706F,
	0x034, 0x0002604F,
	0x034, 0x0002504C,
	0x034, 0x00024049,
	0x034, 0x00023046,
	0x034, 0x00022009,
	0x034, 0x00021006,
	0x034, 0x00020003,
	0xA0000000,	0x00000000,
	0x034, 0x0002ADF5,
	0x034, 0x00029DF2,
	0x034, 0x00028DEF,
	0x034, 0x00027DEC,
	0x034, 0x00026DE9,
	0x034, 0x00025DE6,
	0x034, 0x00024DE3,
	0x034, 0x000238C8,
	0x034, 0x000228C5,
	0x034, 0x000218C2,
	0x034, 0x000208C0,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000A0B2,
	0x034, 0x000090AF,
	0x034, 0x00008070,
	0x034, 0x0000706D,
	0x034, 0x00006050,
	0x034, 0x0000504D,
	0x034, 0x0000404A,
	0x034, 0x00003047,
	0x034, 0x0000200A,
	0x034, 0x00001007,
	0x034, 0x00000004,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x034, 0x0000A0B2,
	0x034, 0x000090AF,
	0x034, 0x00008070,
	0x034, 0x0000706D,
	0x034, 0x0000604D,
	0x034, 0x0000504A,
	0x034, 0x00004047,
	0x034, 0x00003044,
	0x034, 0x00002007,
	0x034, 0x00001004,
	0x034, 0x00000001,
	0xA0000000,	0x00000000,
	0x034, 0x0000AFF7,
	0x034, 0x00009DF7,
	0x034, 0x00008DF4,
	0x034, 0x00007DF1,
	0x034, 0x00006DEE,
	0x034, 0x00005DEB,
	0x034, 0x00004DE8,
	0x034, 0x000038CC,
	0x034, 0x000028C9,
	0x034, 0x000018C6,
	0x034, 0x000008C3,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000040,
	0x035, 0x000001D4,
	0x035, 0x000081D4,
	0x035, 0x000101D4,
	0x035, 0x000201B4,
	0x035, 0x000281B4,
	0x035, 0x000301B4,
	0x035, 0x000401B4,
	0x035, 0x000481B4,
	0x035, 0x000501B4,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000040,
	0x035, 0x000001D4,
	0x035, 0x000081D4,
	0x035, 0x000101D4,
	0x035, 0x000201B4,
	0x035, 0x000281B4,
	0x035, 0x000301B4,
	0x035, 0x000401B4,
	0x035, 0x000481B4,
	0x035, 0x000501B4,
	0xA0000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000040,
	0x035, 0x00000188,
	0x035, 0x00008147,
	0x035, 0x00010147,
	0x035, 0x000201D7,
	0x035, 0x000281D7,
	0x035, 0x000301D7,
	0x035, 0x000401D8,
	0x035, 0x000481D8,
	0x035, 0x000501D8,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000010,
	0x036, 0x00004BFB,
	0x036, 0x0000CBFB,
	0x036, 0x00014BFB,
	0x036, 0x0001CBFB,
	0x036, 0x00024F4B,
	0x036, 0x0002CF4B,
	0x036, 0x00034F4B,
	0x036, 0x0003CF4B,
	0x036, 0x00044F4B,
	0x036, 0x0004CF4B,
	0x036, 0x00054F4B,
	0x036, 0x0005CF4B,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000010,
	0x036, 0x00004BFB,
	0x036, 0x0000CBFB,
	0x036, 0x00014BFB,
	0x036, 0x0001CBFB,
	0x036, 0x00024F4B,
	0x036, 0x0002CF4B,
	0x036, 0x00034F4B,
	0x036, 0x0003CF4B,
	0x036, 0x00044F4B,
	0x036, 0x0004CF4B,
	0x036, 0x00054F4B,
	0x036, 0x0005CF4B,
	0xA0000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000010,
	0x036, 0x00084EB4,
	0x036, 0x0008CC35,
	0x036, 0x00094C35,
	0x036, 0x0009CC35,
	0x036, 0x000A4C35,
	0x036, 0x000ACC35,
	0x036, 0x000B4C35,
	0x036, 0x000BCC35,
	0x036, 0x000C4C34,
	0x036, 0x000CCC35,
	0x036, 0x000D4C35,
	0x036, 0x000DCC35,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x0EF, 0x00000008,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x000002CC,
	0x03C, 0x00000522,
	0x03C, 0x00000902,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x03C, 0x000002CC,
	0x03C, 0x00000522,
	0x03C, 0x00000902,
	0xA0000000,	0x00000000,
	0x03C, 0x000002A8,
	0x03C, 0x000005A2,
	0x03C, 0x00000880,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000002,
	0x0DF, 0x00000080,
	0x01F, 0x00000064,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000FDD43,
	0x062, 0x00038F4B,
	0x063, 0x00032117,
	0x064, 0x000194AC,
	0x065, 0x000931D1,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x061, 0x000FDD43,
	0x062, 0x00038F4B,
	0x063, 0x00032117,
	0x064, 0x000194AC,
	0x065, 0x000931D2,
	0xA0000000,	0x00000000,
	0x061, 0x000E5D53,
	0x062, 0x00038FCD,
	0x063, 0x000114EB,
	0x064, 0x000196AC,
	0x065, 0x000911D7,
	0xB0000000,	0x00000000,
	0x008, 0x00008400,
	0x01C, 0x000739D2,
	0x0B4, 0x0001E78D,
	0x018, 0x0001F12A,
	0xFFE, 0x00000000,
	0xFFE, 0x00000000,
	0xFFE, 0x00000000,
	0xFFE, 0x00000000,
	0x0B4, 0x0001A78D,
	0x018, 0x0001712A,
};

RTW_DECL_TABLE_RF_RADIO(rtw8812a_rf_a, A);

static const u32 rtw8812a_rf_b[] = {
	0x056, 0x00051CF2,
	0x066, 0x00040000,
	0x089, 0x00000080,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x086, 0x00014B3A,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
	0x086, 0x00014B3A,
	0xA0000000,	0x00000000,
	0x086, 0x00014B38,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x08B, 0x00080180,
	0xA0000000,	0x00000000,
	0x08B, 0x00087180,
	0xB0000000,	0x00000000,
	0x018, 0x00000006,
	0x0EF, 0x00002000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
	0x03B, 0x0003F218,
	0x03B, 0x00030A58,
	0x03B, 0x0002FA58,
	0x03B, 0x00022590,
	0x03B, 0x0001FA50,
	0x03B, 0x00010248,
	0x03B, 0x00008240,
	0x90000001,	0x00000005,	0x40000000,	0x00000000,
	0x03B, 0x0003F218,
	0x03B, 0x00030A58,
	0x03B, 0x0002FA58,
	0x03B, 0x00022590,
	0x03B, 0x0001FA50,
	0x03B, 0x00010248,
	0x03B, 0x00008240,
	0xA0000000,	0x00000000,
	0x03B, 0x00038A58,
	0x03B, 0x00037A58,
	0x03B, 0x0002A590,
	0x03B, 0x00027A50,
	0x03B, 0x00018248,
	0x03B, 0x00010240,
	0x03B, 0x00008240,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000100,
	0x80000002,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000A4EE,
	0x034, 0x00009076,
	0x034, 0x00008073,
	0x034, 0x00007070,
	0x034, 0x0000606D,
	0x034, 0x0000506A,
	0x034, 0x00004049,
	0x034, 0x00003046,
	0x034, 0x00002028,
	0x034, 0x00001025,
	0x034, 0x00000022,
	0xA0000000,	0x00000000,
	0x034, 0x0000ADF4,
	0x034, 0x00009DF1,
	0x034, 0x00008DEE,
	0x034, 0x00007DEB,
	0x034, 0x00006DE8,
	0x034, 0x00005DE5,
	0x034, 0x00004DE2,
	0x034, 0x00003CE6,
	0x034, 0x000024E7,
	0x034, 0x000014E4,
	0x034, 0x000004E1,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x0EF, 0x000020A2,
	0x0DF, 0x00000080,
	0x035, 0x00000192,
	0x035, 0x00008192,
	0x035, 0x00010192,
	0x036, 0x00000024,
	0x036, 0x00008024,
	0x036, 0x00010024,
	0x036, 0x00018024,
	0x0EF, 0x00000000,
	0x051, 0x00000C21,
	0x052, 0x000006D9,
	0x053, 0x000FC649,
	0x054, 0x0000017E,
	0x0EF, 0x00000002,
	0x008, 0x00008400,
	0x018, 0x0001712A,
	0x0EF, 0x00001000,
	0x03A, 0x00000080,
	0x03B, 0x0003A02C,
	0x03C, 0x00004000,
	0x03A, 0x00000400,
	0x03B, 0x0003202C,
	0x03C, 0x00010000,
	0x03A, 0x000000A0,
	0x03B, 0x0002B064,
	0x03C, 0x00004000,
	0x03A, 0x000000D8,
	0x03B, 0x00023070,
	0x03C, 0x00004000,
	0x03A, 0x00000468,
	0x03B, 0x0001B870,
	0x03C, 0x00010000,
	0x03A, 0x00000098,
	0x03B, 0x00012085,
	0x03C, 0x000E4000,
	0x03A, 0x00000418,
	0x03B, 0x0000A080,
	0x03C, 0x000F0000,
	0x03A, 0x00000418,
	0x03B, 0x00002080,
	0x03C, 0x00010000,
	0x03A, 0x00000080,
	0x03B, 0x0007A02C,
	0x03C, 0x00004000,
	0x03A, 0x00000400,
	0x03B, 0x0007202C,
	0x03C, 0x00010000,
	0x03A, 0x000000A0,
	0x03B, 0x0006B064,
	0x03C, 0x00004000,
	0x03A, 0x000000D8,
	0x03B, 0x00063070,
	0x03C, 0x00004000,
	0x03A, 0x00000468,
	0x03B, 0x0005B870,
	0x03C, 0x00010000,
	0x03A, 0x00000098,
	0x03B, 0x00052085,
	0x03C, 0x000E4000,
	0x03A, 0x00000418,
	0x03B, 0x0004A080,
	0x03C, 0x000F0000,
	0x03A, 0x00000418,
	0x03B, 0x00042080,
	0x03C, 0x00010000,
	0x03A, 0x00000080,
	0x03B, 0x000BA02C,
	0x03C, 0x00004000,
	0x03A, 0x00000400,
	0x03B, 0x000B202C,
	0x03C, 0x00010000,
	0x03A, 0x000000A0,
	0x03B, 0x000AB064,
	0x03C, 0x00004000,
	0x03A, 0x000000D8,
	0x03B, 0x000A3070,
	0x03C, 0x00004000,
	0x03A, 0x00000468,
	0x03B, 0x0009B870,
	0x03C, 0x00010000,
	0x03A, 0x00000098,
	0x03B, 0x00092085,
	0x03C, 0x000E4000,
	0x03A, 0x00000418,
	0x03B, 0x0008A080,
	0x03C, 0x000F0000,
	0x03A, 0x00000418,
	0x03B, 0x00082080,
	0x03C, 0x00010000,
	0x0EF, 0x00001100,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0004A0B2,
	0x034, 0x000490AF,
	0x034, 0x00048070,
	0x034, 0x0004706D,
	0x034, 0x00046050,
	0x034, 0x0004504D,
	0x034, 0x0004404A,
	0x034, 0x00043047,
	0x034, 0x0004200A,
	0x034, 0x00041007,
	0x034, 0x00040004,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x034, 0x0004A0B1,
	0x034, 0x000490AE,
	0x034, 0x0004806F,
	0x034, 0x0004706C,
	0x034, 0x0004604C,
	0x034, 0x00045049,
	0x034, 0x00044046,
	0x034, 0x00043043,
	0x034, 0x00042006,
	0x034, 0x00041003,
	0x034, 0x00040000,
	0xA0000000,	0x00000000,
	0x034, 0x0004ADF5,
	0x034, 0x00049DF2,
	0x034, 0x00048DEF,
	0x034, 0x00047DEC,
	0x034, 0x00046DE9,
	0x034, 0x00045DE6,
	0x034, 0x00044DE3,
	0x034, 0x000438C8,
	0x034, 0x000428C5,
	0x034, 0x000418C2,
	0x034, 0x000408C0,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0002A0B2,
	0x034, 0x000290AF,
	0x034, 0x00028070,
	0x034, 0x0002706D,
	0x034, 0x00026050,
	0x034, 0x0002504D,
	0x034, 0x0002404A,
	0x034, 0x00023047,
	0x034, 0x0002200A,
	0x034, 0x00021007,
	0x034, 0x00020004,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x034, 0x0002A0B3,
	0x034, 0x000290B0,
	0x034, 0x00028071,
	0x034, 0x0002706E,
	0x034, 0x0002604E,
	0x034, 0x0002504B,
	0x034, 0x00024048,
	0x034, 0x00023045,
	0x034, 0x00022008,
	0x034, 0x00021005,
	0x034, 0x00020002,
	0xA0000000,	0x00000000,
	0x034, 0x0002ADF5,
	0x034, 0x00029DF2,
	0x034, 0x00028DEF,
	0x034, 0x00027DEC,
	0x034, 0x00026DE9,
	0x034, 0x00025DE6,
	0x034, 0x00024DE3,
	0x034, 0x000238C8,
	0x034, 0x000228C5,
	0x034, 0x000218C2,
	0x034, 0x000208C0,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x034, 0x0000A0B2,
	0x034, 0x000090AF,
	0x034, 0x00008070,
	0x034, 0x0000706D,
	0x034, 0x00006050,
	0x034, 0x0000504D,
	0x034, 0x0000404A,
	0x034, 0x00003047,
	0x034, 0x0000200A,
	0x034, 0x00001007,
	0x034, 0x00000004,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x034, 0x0000A0B3,
	0x034, 0x000090B0,
	0x034, 0x00008070,
	0x034, 0x0000706D,
	0x034, 0x0000604D,
	0x034, 0x0000504A,
	0x034, 0x00004047,
	0x034, 0x00003044,
	0x034, 0x00002007,
	0x034, 0x00001004,
	0x034, 0x00000001,
	0xA0000000,	0x00000000,
	0x034, 0x0000AFF7,
	0x034, 0x00009DF7,
	0x034, 0x00008DF4,
	0x034, 0x00007DF1,
	0x034, 0x00006DEE,
	0x034, 0x00005DEB,
	0x034, 0x00004DE8,
	0x034, 0x000038CC,
	0x034, 0x000028C9,
	0x034, 0x000018C6,
	0x034, 0x000008C3,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000040,
	0x035, 0x000001C5,
	0x035, 0x000081C5,
	0x035, 0x000101C5,
	0x035, 0x00020174,
	0x035, 0x00028174,
	0x035, 0x00030174,
	0x035, 0x00040185,
	0x035, 0x00048185,
	0x035, 0x00050185,
	0x0EF, 0x00000000,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000040,
	0x035, 0x000001C5,
	0x035, 0x000081C5,
	0x035, 0x000101C5,
	0x035, 0x00020174,
	0x035, 0x00028174,
	0x035, 0x00030174,
	0x035, 0x00040185,
	0x035, 0x00048185,
	0x035, 0x00050185,
	0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000040,
	0x035, 0x00000188,
	0x035, 0x00008147,
	0x035, 0x00010147,
	0x035, 0x000201D7,
	0x035, 0x000281D7,
	0x035, 0x000301D7,
	0x035, 0x000401D8,
	0x035, 0x000481D8,
	0x035, 0x000501D8,
	0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000010,
	0x036, 0x00005B8B,
	0x036, 0x0000DB8B,
	0x036, 0x00015B8B,
	0x036, 0x0001DB8B,
	0x036, 0x000262DB,
	0x036, 0x0002E2DB,
	0x036, 0x000362DB,
	0x036, 0x0003E2DB,
	0x036, 0x0004553B,
	0x036, 0x0004D53B,
	0x036, 0x0005553B,
	0x036, 0x0005D53B,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000010,
	0x036, 0x00005B8B,
	0x036, 0x0000DB8B,
	0x036, 0x00015B8B,
	0x036, 0x0001DB8B,
	0x036, 0x000262DB,
	0x036, 0x0002E2DB,
	0x036, 0x000362DB,
	0x036, 0x0003E2DB,
	0x036, 0x0004553B,
	0x036, 0x0004D53B,
	0x036, 0x0005553B,
	0x036, 0x0005D53B,
	0xA0000000,	0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000010,
	0x036, 0x00084EB4,
	0x036, 0x0008CC35,
	0x036, 0x00094C35,
	0x036, 0x0009CC35,
	0x036, 0x000A4C35,
	0x036, 0x000ACC35,
	0x036, 0x000B4C35,
	0x036, 0x000BCC35,
	0x036, 0x000C4C34,
	0x036, 0x000CCC35,
	0x036, 0x000D4C35,
	0x036, 0x000DCC35,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x0EF, 0x00000008,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x03C, 0x000002DC,
	0x03C, 0x00000524,
	0x03C, 0x00000902,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x03C, 0x000002DC,
	0x03C, 0x00000524,
	0x03C, 0x00000902,
	0xA0000000,	0x00000000,
	0x03C, 0x000002A8,
	0x03C, 0x000005A2,
	0x03C, 0x00000880,
	0xB0000000,	0x00000000,
	0x0EF, 0x00000000,
	0x018, 0x0001712A,
	0x0EF, 0x00000002,
	0x0DF, 0x00000080,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000EAC43,
	0x062, 0x00038F47,
	0x063, 0x00031157,
	0x064, 0x0001C4AC,
	0x065, 0x000931D1,
	0x90000008,	0x05000000,	0x40000000,	0x00000000,
	0x061, 0x000EAC43,
	0x062, 0x00038F47,
	0x063, 0x00031157,
	0x064, 0x0001C4AC,
	0x065, 0x000931D2,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
	0x061, 0x000EAC43,
	0x062, 0x00038F47,
	0x063, 0x00031157,
	0x064, 0x0001C4AC,
	0x065, 0x000931D1,
	0xA0000000,	0x00000000,
	0x061, 0x000E5D53,
	0x062, 0x00038FCD,
	0x063, 0x000114EB,
	0x064, 0x000196AC,
	0x065, 0x000911D7,
	0xB0000000,	0x00000000,
	0x008, 0x00008400,
};

RTW_DECL_TABLE_RF_RADIO(rtw8812a_rf_b, B);

static const struct rtw_txpwr_lmt_cfg_pair rtw8812a_txpwr_lmt[] = {
	{ 0, 0, 0, 0, 1, 36, },
	{ 2, 0, 0, 0, 1, 32, },
	{ 1, 0, 0, 0, 1, 32, },
	{ 0, 0, 0, 0, 2, 36, },
	{ 2, 0, 0, 0, 2, 32, },
	{ 1, 0, 0, 0, 2, 32, },
	{ 0, 0, 0, 0, 3, 36, },
	{ 2, 0, 0, 0, 3, 32, },
	{ 1, 0, 0, 0, 3, 32, },
	{ 0, 0, 0, 0, 4, 36, },
	{ 2, 0, 0, 0, 4, 32, },
	{ 1, 0, 0, 0, 4, 32, },
	{ 0, 0, 0, 0, 5, 36, },
	{ 2, 0, 0, 0, 5, 32, },
	{ 1, 0, 0, 0, 5, 32, },
	{ 0, 0, 0, 0, 6, 36, },
	{ 2, 0, 0, 0, 6, 32, },
	{ 1, 0, 0, 0, 6, 32, },
	{ 0, 0, 0, 0, 7, 36, },
	{ 2, 0, 0, 0, 7, 32, },
	{ 1, 0, 0, 0, 7, 32, },
	{ 0, 0, 0, 0, 8, 36, },
	{ 2, 0, 0, 0, 8, 32, },
	{ 1, 0, 0, 0, 8, 32, },
	{ 0, 0, 0, 0, 9, 36, },
	{ 2, 0, 0, 0, 9, 32, },
	{ 1, 0, 0, 0, 9, 32, },
	{ 0, 0, 0, 0, 10, 36, },
	{ 2, 0, 0, 0, 10, 32, },
	{ 1, 0, 0, 0, 10, 32, },
	{ 0, 0, 0, 0, 11, 36, },
	{ 2, 0, 0, 0, 11, 32, },
	{ 1, 0, 0, 0, 11, 32, },
	{ 0, 0, 0, 0, 12, 63, },
	{ 2, 0, 0, 0, 12, 32, },
	{ 1, 0, 0, 0, 12, 32, },
	{ 0, 0, 0, 0, 13, 63, },
	{ 2, 0, 0, 0, 13, 32, },
	{ 1, 0, 0, 0, 13, 32, },
	{ 0, 0, 0, 0, 14, 63, },
	{ 2, 0, 0, 0, 14, 63, },
	{ 1, 0, 0, 0, 14, 32, },
	{ 0, 0, 0, 1, 1, 34, },
	{ 2, 0, 0, 1, 1, 32, },
	{ 1, 0, 0, 1, 1, 32, },
	{ 0, 0, 0, 1, 2, 36, },
	{ 2, 0, 0, 1, 2, 32, },
	{ 1, 0, 0, 1, 2, 32, },
	{ 0, 0, 0, 1, 3, 36, },
	{ 2, 0, 0, 1, 3, 32, },
	{ 1, 0, 0, 1, 3, 32, },
	{ 0, 0, 0, 1, 4, 36, },
	{ 2, 0, 0, 1, 4, 32, },
	{ 1, 0, 0, 1, 4, 32, },
	{ 0, 0, 0, 1, 5, 36, },
	{ 2, 0, 0, 1, 5, 32, },
	{ 1, 0, 0, 1, 5, 32, },
	{ 0, 0, 0, 1, 6, 36, },
	{ 2, 0, 0, 1, 6, 32, },
	{ 1, 0, 0, 1, 6, 32, },
	{ 0, 0, 0, 1, 7, 36, },
	{ 2, 0, 0, 1, 7, 32, },
	{ 1, 0, 0, 1, 7, 32, },
	{ 0, 0, 0, 1, 8, 36, },
	{ 2, 0, 0, 1, 8, 32, },
	{ 1, 0, 0, 1, 8, 32, },
	{ 0, 0, 0, 1, 9, 36, },
	{ 2, 0, 0, 1, 9, 32, },
	{ 1, 0, 0, 1, 9, 32, },
	{ 0, 0, 0, 1, 10, 36, },
	{ 2, 0, 0, 1, 10, 32, },
	{ 1, 0, 0, 1, 10, 32, },
	{ 0, 0, 0, 1, 11, 32, },
	{ 2, 0, 0, 1, 11, 32, },
	{ 1, 0, 0, 1, 11, 32, },
	{ 0, 0, 0, 1, 12, 63, },
	{ 2, 0, 0, 1, 12, 32, },
	{ 1, 0, 0, 1, 12, 32, },
	{ 0, 0, 0, 1, 13, 63, },
	{ 2, 0, 0, 1, 13, 32, },
	{ 1, 0, 0, 1, 13, 32, },
	{ 0, 0, 0, 1, 14, 63, },
	{ 2, 0, 0, 1, 14, 63, },
	{ 1, 0, 0, 1, 14, 63, },
	{ 0, 0, 0, 2, 1, 34, },
	{ 2, 0, 0, 2, 1, 32, },
	{ 1, 0, 0, 2, 1, 32, },
	{ 0, 0, 0, 2, 2, 36, },
	{ 2, 0, 0, 2, 2, 32, },
	{ 1, 0, 0, 2, 2, 32, },
	{ 0, 0, 0, 2, 3, 36, },
	{ 2, 0, 0, 2, 3, 32, },
	{ 1, 0, 0, 2, 3, 32, },
	{ 0, 0, 0, 2, 4, 36, },
	{ 2, 0, 0, 2, 4, 32, },
	{ 1, 0, 0, 2, 4, 32, },
	{ 0, 0, 0, 2, 5, 36, },
	{ 2, 0, 0, 2, 5, 32, },
	{ 1, 0, 0, 2, 5, 32, },
	{ 0, 0, 0, 2, 6, 36, },
	{ 2, 0, 0, 2, 6, 32, },
	{ 1, 0, 0, 2, 6, 32, },
	{ 0, 0, 0, 2, 7, 36, },
	{ 2, 0, 0, 2, 7, 32, },
	{ 1, 0, 0, 2, 7, 32, },
	{ 0, 0, 0, 2, 8, 36, },
	{ 2, 0, 0, 2, 8, 32, },
	{ 1, 0, 0, 2, 8, 32, },
	{ 0, 0, 0, 2, 9, 36, },
	{ 2, 0, 0, 2, 9, 32, },
	{ 1, 0, 0, 2, 9, 32, },
	{ 0, 0, 0, 2, 10, 36, },
	{ 2, 0, 0, 2, 10, 32, },
	{ 1, 0, 0, 2, 10, 32, },
	{ 0, 0, 0, 2, 11, 32, },
	{ 2, 0, 0, 2, 11, 32, },
	{ 1, 0, 0, 2, 11, 32, },
	{ 0, 0, 0, 2, 12, 63, },
	{ 2, 0, 0, 2, 12, 32, },
	{ 1, 0, 0, 2, 12, 32, },
	{ 0, 0, 0, 2, 13, 63, },
	{ 2, 0, 0, 2, 13, 32, },
	{ 1, 0, 0, 2, 13, 32, },
	{ 0, 0, 0, 2, 14, 63, },
	{ 2, 0, 0, 2, 14, 63, },
	{ 1, 0, 0, 2, 14, 63, },
	{ 0, 0, 0, 3, 1, 32, },
	{ 2, 0, 0, 3, 1, 32, },
	{ 1, 0, 0, 3, 1, 32, },
	{ 0, 0, 0, 3, 2, 34, },
	{ 2, 0, 0, 3, 2, 32, },
	{ 1, 0, 0, 3, 2, 32, },
	{ 0, 0, 0, 3, 3, 34, },
	{ 2, 0, 0, 3, 3, 32, },
	{ 1, 0, 0, 3, 3, 32, },
	{ 0, 0, 0, 3, 4, 34, },
	{ 2, 0, 0, 3, 4, 32, },
	{ 1, 0, 0, 3, 4, 32, },
	{ 0, 0, 0, 3, 5, 34, },
	{ 2, 0, 0, 3, 5, 32, },
	{ 1, 0, 0, 3, 5, 32, },
	{ 0, 0, 0, 3, 6, 34, },
	{ 2, 0, 0, 3, 6, 32, },
	{ 1, 0, 0, 3, 6, 32, },
	{ 0, 0, 0, 3, 7, 34, },
	{ 2, 0, 0, 3, 7, 32, },
	{ 1, 0, 0, 3, 7, 32, },
	{ 0, 0, 0, 3, 8, 34, },
	{ 2, 0, 0, 3, 8, 32, },
	{ 1, 0, 0, 3, 8, 32, },
	{ 0, 0, 0, 3, 9, 34, },
	{ 2, 0, 0, 3, 9, 32, },
	{ 1, 0, 0, 3, 9, 32, },
	{ 0, 0, 0, 3, 10, 34, },
	{ 2, 0, 0, 3, 10, 32, },
	{ 1, 0, 0, 3, 10, 32, },
	{ 0, 0, 0, 3, 11, 30, },
	{ 2, 0, 0, 3, 11, 32, },
	{ 1, 0, 0, 3, 11, 32, },
	{ 0, 0, 0, 3, 12, 63, },
	{ 2, 0, 0, 3, 12, 32, },
	{ 1, 0, 0, 3, 12, 32, },
	{ 0, 0, 0, 3, 13, 63, },
	{ 2, 0, 0, 3, 13, 32, },
	{ 1, 0, 0, 3, 13, 32, },
	{ 0, 0, 0, 3, 14, 63, },
	{ 2, 0, 0, 3, 14, 63, },
	{ 1, 0, 0, 3, 14, 63, },
	{ 0, 0, 1, 2, 1, 63, },
	{ 2, 0, 1, 2, 1, 63, },
	{ 1, 0, 1, 2, 1, 63, },
	{ 0, 0, 1, 2, 2, 63, },
	{ 2, 0, 1, 2, 2, 63, },
	{ 1, 0, 1, 2, 2, 63, },
	{ 0, 0, 1, 2, 3, 32, },
	{ 2, 0, 1, 2, 3, 32, },
	{ 1, 0, 1, 2, 3, 32, },
	{ 0, 0, 1, 2, 4, 36, },
	{ 2, 0, 1, 2, 4, 32, },
	{ 1, 0, 1, 2, 4, 32, },
	{ 0, 0, 1, 2, 5, 36, },
	{ 2, 0, 1, 2, 5, 32, },
	{ 1, 0, 1, 2, 5, 32, },
	{ 0, 0, 1, 2, 6, 36, },
	{ 2, 0, 1, 2, 6, 32, },
	{ 1, 0, 1, 2, 6, 32, },
	{ 0, 0, 1, 2, 7, 36, },
	{ 2, 0, 1, 2, 7, 32, },
	{ 1, 0, 1, 2, 7, 32, },
	{ 0, 0, 1, 2, 8, 36, },
	{ 2, 0, 1, 2, 8, 32, },
	{ 1, 0, 1, 2, 8, 32, },
	{ 0, 0, 1, 2, 9, 36, },
	{ 2, 0, 1, 2, 9, 32, },
	{ 1, 0, 1, 2, 9, 32, },
	{ 0, 0, 1, 2, 10, 36, },
	{ 2, 0, 1, 2, 10, 32, },
	{ 1, 0, 1, 2, 10, 32, },
	{ 0, 0, 1, 2, 11, 32, },
	{ 2, 0, 1, 2, 11, 32, },
	{ 1, 0, 1, 2, 11, 32, },
	{ 0, 0, 1, 2, 12, 63, },
	{ 2, 0, 1, 2, 12, 32, },
	{ 1, 0, 1, 2, 12, 32, },
	{ 0, 0, 1, 2, 13, 63, },
	{ 2, 0, 1, 2, 13, 32, },
	{ 1, 0, 1, 2, 13, 32, },
	{ 0, 0, 1, 2, 14, 63, },
	{ 2, 0, 1, 2, 14, 63, },
	{ 1, 0, 1, 2, 14, 63, },
	{ 0, 0, 1, 3, 1, 63, },
	{ 2, 0, 1, 3, 1, 63, },
	{ 1, 0, 1, 3, 1, 63, },
	{ 0, 0, 1, 3, 2, 63, },
	{ 2, 0, 1, 3, 2, 63, },
	{ 1, 0, 1, 3, 2, 63, },
	{ 0, 0, 1, 3, 3, 30, },
	{ 2, 0, 1, 3, 3, 30, },
	{ 1, 0, 1, 3, 3, 30, },
	{ 0, 0, 1, 3, 4, 34, },
	{ 2, 0, 1, 3, 4, 30, },
	{ 1, 0, 1, 3, 4, 30, },
	{ 0, 0, 1, 3, 5, 34, },
	{ 2, 0, 1, 3, 5, 30, },
	{ 1, 0, 1, 3, 5, 30, },
	{ 0, 0, 1, 3, 6, 34, },
	{ 2, 0, 1, 3, 6, 30, },
	{ 1, 0, 1, 3, 6, 30, },
	{ 0, 0, 1, 3, 7, 34, },
	{ 2, 0, 1, 3, 7, 30, },
	{ 1, 0, 1, 3, 7, 30, },
	{ 0, 0, 1, 3, 8, 34, },
	{ 2, 0, 1, 3, 8, 30, },
	{ 1, 0, 1, 3, 8, 30, },
	{ 0, 0, 1, 3, 9, 34, },
	{ 2, 0, 1, 3, 9, 30, },
	{ 1, 0, 1, 3, 9, 30, },
	{ 0, 0, 1, 3, 10, 34, },
	{ 2, 0, 1, 3, 10, 30, },
	{ 1, 0, 1, 3, 10, 30, },
	{ 0, 0, 1, 3, 11, 30, },
	{ 2, 0, 1, 3, 11, 30, },
	{ 1, 0, 1, 3, 11, 30, },
	{ 0, 0, 1, 3, 12, 63, },
	{ 2, 0, 1, 3, 12, 32, },
	{ 1, 0, 1, 3, 12, 32, },
	{ 0, 0, 1, 3, 13, 63, },
	{ 2, 0, 1, 3, 13, 32, },
	{ 1, 0, 1, 3, 13, 32, },
	{ 0, 0, 1, 3, 14, 63, },
	{ 2, 0, 1, 3, 14, 63, },
	{ 1, 0, 1, 3, 14, 63, },
	{ 0, 1, 0, 1, 36, 30, },
	{ 2, 1, 0, 1, 36, 32, },
	{ 1, 1, 0, 1, 36, 32, },
	{ 0, 1, 0, 1, 40, 30, },
	{ 2, 1, 0, 1, 40, 32, },
	{ 1, 1, 0, 1, 40, 32, },
	{ 0, 1, 0, 1, 44, 30, },
	{ 2, 1, 0, 1, 44, 32, },
	{ 1, 1, 0, 1, 44, 32, },
	{ 0, 1, 0, 1, 48, 30, },
	{ 2, 1, 0, 1, 48, 32, },
	{ 1, 1, 0, 1, 48, 32, },
	{ 0, 1, 0, 1, 52, 36, },
	{ 2, 1, 0, 1, 52, 32, },
	{ 1, 1, 0, 1, 52, 32, },
	{ 0, 1, 0, 1, 56, 34, },
	{ 2, 1, 0, 1, 56, 32, },
	{ 1, 1, 0, 1, 56, 32, },
	{ 0, 1, 0, 1, 60, 32, },
	{ 2, 1, 0, 1, 60, 32, },
	{ 1, 1, 0, 1, 60, 32, },
	{ 0, 1, 0, 1, 64, 28, },
	{ 2, 1, 0, 1, 64, 32, },
	{ 1, 1, 0, 1, 64, 32, },
	{ 0, 1, 0, 1, 100, 30, },
	{ 2, 1, 0, 1, 100, 32, },
	{ 1, 1, 0, 1, 100, 32, },
	{ 0, 1, 0, 1, 104, 30, },
	{ 2, 1, 0, 1, 104, 32, },
	{ 1, 1, 0, 1, 104, 32, },
	{ 0, 1, 0, 1, 108, 32, },
	{ 2, 1, 0, 1, 108, 32, },
	{ 1, 1, 0, 1, 108, 32, },
	{ 0, 1, 0, 1, 112, 34, },
	{ 2, 1, 0, 1, 112, 32, },
	{ 1, 1, 0, 1, 112, 32, },
	{ 0, 1, 0, 1, 116, 34, },
	{ 2, 1, 0, 1, 116, 32, },
	{ 1, 1, 0, 1, 116, 32, },
	{ 0, 1, 0, 1, 120, 36, },
	{ 2, 1, 0, 1, 120, 32, },
	{ 1, 1, 0, 1, 120, 32, },
	{ 0, 1, 0, 1, 124, 34, },
	{ 2, 1, 0, 1, 124, 32, },
	{ 1, 1, 0, 1, 124, 32, },
	{ 0, 1, 0, 1, 128, 32, },
	{ 2, 1, 0, 1, 128, 32, },
	{ 1, 1, 0, 1, 128, 32, },
	{ 0, 1, 0, 1, 132, 30, },
	{ 2, 1, 0, 1, 132, 32, },
	{ 1, 1, 0, 1, 132, 32, },
	{ 0, 1, 0, 1, 136, 30, },
	{ 2, 1, 0, 1, 136, 32, },
	{ 1, 1, 0, 1, 136, 32, },
	{ 0, 1, 0, 1, 140, 28, },
	{ 2, 1, 0, 1, 140, 32, },
	{ 1, 1, 0, 1, 140, 32, },
	{ 0, 1, 0, 1, 149, 36, },
	{ 2, 1, 0, 1, 149, 32, },
	{ 1, 1, 0, 1, 149, 63, },
	{ 0, 1, 0, 1, 153, 36, },
	{ 2, 1, 0, 1, 153, 32, },
	{ 1, 1, 0, 1, 153, 63, },
	{ 0, 1, 0, 1, 157, 36, },
	{ 2, 1, 0, 1, 157, 32, },
	{ 1, 1, 0, 1, 157, 63, },
	{ 0, 1, 0, 1, 161, 36, },
	{ 2, 1, 0, 1, 161, 32, },
	{ 1, 1, 0, 1, 161, 63, },
	{ 0, 1, 0, 1, 165, 36, },
	{ 2, 1, 0, 1, 165, 32, },
	{ 1, 1, 0, 1, 165, 63, },
	{ 0, 1, 0, 2, 36, 30, },
	{ 2, 1, 0, 2, 36, 32, },
	{ 1, 1, 0, 2, 36, 32, },
	{ 0, 1, 0, 2, 40, 30, },
	{ 2, 1, 0, 2, 40, 32, },
	{ 1, 1, 0, 2, 40, 32, },
	{ 0, 1, 0, 2, 44, 30, },
	{ 2, 1, 0, 2, 44, 32, },
	{ 1, 1, 0, 2, 44, 32, },
	{ 0, 1, 0, 2, 48, 30, },
	{ 2, 1, 0, 2, 48, 32, },
	{ 1, 1, 0, 2, 48, 32, },
	{ 0, 1, 0, 2, 52, 36, },
	{ 2, 1, 0, 2, 52, 32, },
	{ 1, 1, 0, 2, 52, 32, },
	{ 0, 1, 0, 2, 56, 34, },
	{ 2, 1, 0, 2, 56, 32, },
	{ 1, 1, 0, 2, 56, 32, },
	{ 0, 1, 0, 2, 60, 32, },
	{ 2, 1, 0, 2, 60, 32, },
	{ 1, 1, 0, 2, 60, 32, },
	{ 0, 1, 0, 2, 64, 28, },
	{ 2, 1, 0, 2, 64, 32, },
	{ 1, 1, 0, 2, 64, 32, },
	{ 0, 1, 0, 2, 100, 30, },
	{ 2, 1, 0, 2, 100, 32, },
	{ 1, 1, 0, 2, 100, 32, },
	{ 0, 1, 0, 2, 104, 30, },
	{ 2, 1, 0, 2, 104, 32, },
	{ 1, 1, 0, 2, 104, 32, },
	{ 0, 1, 0, 2, 108, 32, },
	{ 2, 1, 0, 2, 108, 32, },
	{ 1, 1, 0, 2, 108, 32, },
	{ 0, 1, 0, 2, 112, 34, },
	{ 2, 1, 0, 2, 112, 32, },
	{ 1, 1, 0, 2, 112, 32, },
	{ 0, 1, 0, 2, 116, 34, },
	{ 2, 1, 0, 2, 116, 32, },
	{ 1, 1, 0, 2, 116, 32, },
	{ 0, 1, 0, 2, 120, 36, },
	{ 2, 1, 0, 2, 120, 32, },
	{ 1, 1, 0, 2, 120, 32, },
	{ 0, 1, 0, 2, 124, 34, },
	{ 2, 1, 0, 2, 124, 32, },
	{ 1, 1, 0, 2, 124, 32, },
	{ 0, 1, 0, 2, 128, 32, },
	{ 2, 1, 0, 2, 128, 32, },
	{ 1, 1, 0, 2, 128, 32, },
	{ 0, 1, 0, 2, 132, 30, },
	{ 2, 1, 0, 2, 132, 32, },
	{ 1, 1, 0, 2, 132, 32, },
	{ 0, 1, 0, 2, 136, 30, },
	{ 2, 1, 0, 2, 136, 32, },
	{ 1, 1, 0, 2, 136, 32, },
	{ 0, 1, 0, 2, 140, 28, },
	{ 2, 1, 0, 2, 140, 32, },
	{ 1, 1, 0, 2, 140, 32, },
	{ 0, 1, 0, 2, 149, 36, },
	{ 2, 1, 0, 2, 149, 32, },
	{ 1, 1, 0, 2, 149, 63, },
	{ 0, 1, 0, 2, 153, 36, },
	{ 2, 1, 0, 2, 153, 32, },
	{ 1, 1, 0, 2, 153, 63, },
	{ 0, 1, 0, 2, 157, 36, },
	{ 2, 1, 0, 2, 157, 32, },
	{ 1, 1, 0, 2, 157, 63, },
	{ 0, 1, 0, 2, 161, 36, },
	{ 2, 1, 0, 2, 161, 32, },
	{ 1, 1, 0, 2, 161, 63, },
	{ 0, 1, 0, 2, 165, 36, },
	{ 2, 1, 0, 2, 165, 32, },
	{ 1, 1, 0, 2, 165, 63, },
	{ 0, 1, 0, 3, 36, 28, },
	{ 2, 1, 0, 3, 36, 30, },
	{ 1, 1, 0, 3, 36, 30, },
	{ 0, 1, 0, 3, 40, 28, },
	{ 2, 1, 0, 3, 40, 30, },
	{ 1, 1, 0, 3, 40, 30, },
	{ 0, 1, 0, 3, 44, 28, },
	{ 2, 1, 0, 3, 44, 30, },
	{ 1, 1, 0, 3, 44, 30, },
	{ 0, 1, 0, 3, 48, 28, },
	{ 2, 1, 0, 3, 48, 30, },
	{ 1, 1, 0, 3, 48, 30, },
	{ 0, 1, 0, 3, 52, 34, },
	{ 2, 1, 0, 3, 52, 30, },
	{ 1, 1, 0, 3, 52, 30, },
	{ 0, 1, 0, 3, 56, 32, },
	{ 2, 1, 0, 3, 56, 30, },
	{ 1, 1, 0, 3, 56, 30, },
	{ 0, 1, 0, 3, 60, 30, },
	{ 2, 1, 0, 3, 60, 30, },
	{ 1, 1, 0, 3, 60, 30, },
	{ 0, 1, 0, 3, 64, 26, },
	{ 2, 1, 0, 3, 64, 30, },
	{ 1, 1, 0, 3, 64, 30, },
	{ 0, 1, 0, 3, 100, 28, },
	{ 2, 1, 0, 3, 100, 30, },
	{ 1, 1, 0, 3, 100, 30, },
	{ 0, 1, 0, 3, 104, 28, },
	{ 2, 1, 0, 3, 104, 30, },
	{ 1, 1, 0, 3, 104, 30, },
	{ 0, 1, 0, 3, 108, 30, },
	{ 2, 1, 0, 3, 108, 30, },
	{ 1, 1, 0, 3, 108, 30, },
	{ 0, 1, 0, 3, 112, 32, },
	{ 2, 1, 0, 3, 112, 30, },
	{ 1, 1, 0, 3, 112, 30, },
	{ 0, 1, 0, 3, 116, 32, },
	{ 2, 1, 0, 3, 116, 30, },
	{ 1, 1, 0, 3, 116, 30, },
	{ 0, 1, 0, 3, 120, 34, },
	{ 2, 1, 0, 3, 120, 30, },
	{ 1, 1, 0, 3, 120, 30, },
	{ 0, 1, 0, 3, 124, 32, },
	{ 2, 1, 0, 3, 124, 30, },
	{ 1, 1, 0, 3, 124, 30, },
	{ 0, 1, 0, 3, 128, 30, },
	{ 2, 1, 0, 3, 128, 30, },
	{ 1, 1, 0, 3, 128, 30, },
	{ 0, 1, 0, 3, 132, 28, },
	{ 2, 1, 0, 3, 132, 30, },
	{ 1, 1, 0, 3, 132, 30, },
	{ 0, 1, 0, 3, 136, 28, },
	{ 2, 1, 0, 3, 136, 30, },
	{ 1, 1, 0, 3, 136, 30, },
	{ 0, 1, 0, 3, 140, 26, },
	{ 2, 1, 0, 3, 140, 30, },
	{ 1, 1, 0, 3, 140, 30, },
	{ 0, 1, 0, 3, 149, 34, },
	{ 2, 1, 0, 3, 149, 30, },
	{ 1, 1, 0, 3, 149, 63, },
	{ 0, 1, 0, 3, 153, 34, },
	{ 2, 1, 0, 3, 153, 30, },
	{ 1, 1, 0, 3, 153, 63, },
	{ 0, 1, 0, 3, 157, 34, },
	{ 2, 1, 0, 3, 157, 30, },
	{ 1, 1, 0, 3, 157, 63, },
	{ 0, 1, 0, 3, 161, 34, },
	{ 2, 1, 0, 3, 161, 30, },
	{ 1, 1, 0, 3, 161, 63, },
	{ 0, 1, 0, 3, 165, 34, },
	{ 2, 1, 0, 3, 165, 30, },
	{ 1, 1, 0, 3, 165, 63, },
	{ 0, 1, 1, 2, 38, 30, },
	{ 2, 1, 1, 2, 38, 32, },
	{ 1, 1, 1, 2, 38, 32, },
	{ 0, 1, 1, 2, 46, 30, },
	{ 2, 1, 1, 2, 46, 32, },
	{ 1, 1, 1, 2, 46, 32, },
	{ 0, 1, 1, 2, 54, 32, },
	{ 2, 1, 1, 2, 54, 32, },
	{ 1, 1, 1, 2, 54, 32, },
	{ 0, 1, 1, 2, 62, 32, },
	{ 2, 1, 1, 2, 62, 32, },
	{ 1, 1, 1, 2, 62, 32, },
	{ 0, 1, 1, 2, 102, 28, },
	{ 2, 1, 1, 2, 102, 32, },
	{ 1, 1, 1, 2, 102, 32, },
	{ 0, 1, 1, 2, 110, 32, },
	{ 2, 1, 1, 2, 110, 32, },
	{ 1, 1, 1, 2, 110, 32, },
	{ 0, 1, 1, 2, 118, 36, },
	{ 2, 1, 1, 2, 118, 32, },
	{ 1, 1, 1, 2, 118, 32, },
	{ 0, 1, 1, 2, 126, 34, },
	{ 2, 1, 1, 2, 126, 32, },
	{ 1, 1, 1, 2, 126, 32, },
	{ 0, 1, 1, 2, 134, 32, },
	{ 2, 1, 1, 2, 134, 32, },
	{ 1, 1, 1, 2, 134, 32, },
	{ 0, 1, 1, 2, 151, 36, },
	{ 2, 1, 1, 2, 151, 32, },
	{ 1, 1, 1, 2, 151, 63, },
	{ 0, 1, 1, 2, 159, 36, },
	{ 2, 1, 1, 2, 159, 32, },
	{ 1, 1, 1, 2, 159, 63, },
	{ 0, 1, 1, 3, 38, 28, },
	{ 2, 1, 1, 3, 38, 30, },
	{ 1, 1, 1, 3, 38, 30, },
	{ 0, 1, 1, 3, 46, 28, },
	{ 2, 1, 1, 3, 46, 30, },
	{ 1, 1, 1, 3, 46, 30, },
	{ 0, 1, 1, 3, 54, 30, },
	{ 2, 1, 1, 3, 54, 30, },
	{ 1, 1, 1, 3, 54, 30, },
	{ 0, 1, 1, 3, 62, 30, },
	{ 2, 1, 1, 3, 62, 30, },
	{ 1, 1, 1, 3, 62, 30, },
	{ 0, 1, 1, 3, 102, 26, },
	{ 2, 1, 1, 3, 102, 30, },
	{ 1, 1, 1, 3, 102, 30, },
	{ 0, 1, 1, 3, 110, 30, },
	{ 2, 1, 1, 3, 110, 30, },
	{ 1, 1, 1, 3, 110, 30, },
	{ 0, 1, 1, 3, 118, 34, },
	{ 2, 1, 1, 3, 118, 30, },
	{ 1, 1, 1, 3, 118, 30, },
	{ 0, 1, 1, 3, 126, 32, },
	{ 2, 1, 1, 3, 126, 30, },
	{ 1, 1, 1, 3, 126, 30, },
	{ 0, 1, 1, 3, 134, 30, },
	{ 2, 1, 1, 3, 134, 30, },
	{ 1, 1, 1, 3, 134, 30, },
	{ 0, 1, 1, 3, 151, 34, },
	{ 2, 1, 1, 3, 151, 30, },
	{ 1, 1, 1, 3, 151, 63, },
	{ 0, 1, 1, 3, 159, 34, },
	{ 2, 1, 1, 3, 159, 30, },
	{ 1, 1, 1, 3, 159, 63, },
	{ 0, 1, 2, 4, 42, 30, },
	{ 2, 1, 2, 4, 42, 32, },
	{ 1, 1, 2, 4, 42, 32, },
	{ 0, 1, 2, 4, 58, 28, },
	{ 2, 1, 2, 4, 58, 32, },
	{ 1, 1, 2, 4, 58, 32, },
	{ 0, 1, 2, 4, 106, 30, },
	{ 2, 1, 2, 4, 106, 32, },
	{ 1, 1, 2, 4, 106, 32, },
	{ 0, 1, 2, 4, 122, 34, },
	{ 2, 1, 2, 4, 122, 32, },
	{ 1, 1, 2, 4, 122, 32, },
	{ 0, 1, 2, 4, 155, 36, },
	{ 2, 1, 2, 4, 155, 32, },
	{ 1, 1, 2, 4, 155, 63, },
	{ 0, 1, 2, 5, 42, 28, },
	{ 2, 1, 2, 5, 42, 30, },
	{ 1, 1, 2, 5, 42, 30, },
	{ 0, 1, 2, 5, 58, 26, },
	{ 2, 1, 2, 5, 58, 30, },
	{ 1, 1, 2, 5, 58, 30, },
	{ 0, 1, 2, 5, 106, 28, },
	{ 2, 1, 2, 5, 106, 30, },
	{ 1, 1, 2, 5, 106, 30, },
	{ 0, 1, 2, 5, 122, 32, },
	{ 2, 1, 2, 5, 122, 30, },
	{ 1, 1, 2, 5, 122, 30, },
	{ 0, 1, 2, 5, 155, 34, },
	{ 2, 1, 2, 5, 155, 30, },
	{ 1, 1, 2, 5, 155, 63, },
};

RTW_DECL_TABLE_TXPWR_LMT(rtw8812a_txpwr_lmt);

static const struct rtw_pwr_seq_cmd trans_carddis_to_cardemu_8812a[] = {
	{0x0012,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0014,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x80, 0},
	{0x0015,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x01, 0},
	{0x0023,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x10, 0},
	{0x0046,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0043,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), 0},
	{0x0003,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), BIT(2)},
	{0x0301,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0},
	{0x0024,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0028,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_cardemu_to_act_8812a[] = {
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), 0},
	{0x0006,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(1), BIT(1)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(7), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(0), 0},
	{0x0024,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0028,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_act_to_lps_8812a[] = {
	{0x0301,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0522,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x7F},
	{0x05F8,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x05F9,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FA,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FB,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, 0xFF, 0},
	{0x0c00,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x04},
	{0x0e00,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x04},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_DELAY, 0, RTW_PWR_DELAY_US},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0100,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x03},
	{0x0101,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0553,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(5), BIT(5)},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_act_to_cardemu_8812a[] = {
	{0x0c00,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x04},
	{0x0e00,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x04},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_DELAY, 0, RTW_PWR_DELAY_US},
	{0x0002,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0007,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x2A},
	{0x0008,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x02, 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_POLLING, BIT(1), 0},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

static const struct rtw_pwr_seq_cmd trans_cardemu_to_carddis_8812a[] = {
	{0x0003,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(2), 0},
	{0x0080,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x05},
	{0x0042,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xF0, 0xcc},
	{0x0042,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_PCI_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xF0, 0xEC},
	{0x0043,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x07},
	{0x0045,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0046,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0xff},
	{0x0047,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0},
	{0x0014,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x80, BIT(7)},
	{0x0015,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x01, BIT(0)},
	{0x0012,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x01, 0},
	{0x0023,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x10, BIT(4)},
	{0x0008,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0x02, 0},
	{0x0007,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x001f,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0076,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_USB_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(1), 0},
	{0x0005,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 RTW_PWR_ADDR_MAC,
	 RTW_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0xFFFF,
	 RTW_PWR_CUT_ALL_MSK,
	 RTW_PWR_INTF_ALL_MSK,
	 0,
	 RTW_PWR_CMD_END, 0, 0},
};

const struct rtw_pwr_seq_cmd * const card_enable_flow_8812a[] = {
	trans_carddis_to_cardemu_8812a,
	trans_cardemu_to_act_8812a,
	NULL
};

const struct rtw_pwr_seq_cmd * const enter_lps_flow_8812a[] = {
	trans_act_to_lps_8812a,
	NULL
};

const struct rtw_pwr_seq_cmd * const card_disable_flow_8812a[] = {
	trans_act_to_cardemu_8812a,
	trans_cardemu_to_carddis_8812a,
	NULL
};

static const u8 rtw8812a_pwrtrk_5gb_n[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 13, 13, 14, 14, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 4, 4, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 13, 13, 14, 14, 14, 14, 14, 14},
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 13,
	 13, 14, 14, 15, 16, 16, 16, 16, 16},
};

static const u8 rtw8812a_pwrtrk_5gb_p[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
};

static const u8 rtw8812a_pwrtrk_5ga_n[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 13, 13, 14, 15, 15, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 13, 13, 14, 15, 15, 15, 15, 15},
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 13, 13, 14, 15, 15, 15, 15, 15},
};

static const u8 rtw8812a_pwrtrk_5ga_p[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 7, 7, 8, 8, 9, 10, 11, 11, 11, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 8, 9, 10, 11, 11, 11, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 8, 9, 10, 11, 11, 12, 12, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
};

static const u8 rtw8812a_pwrtrk_2gb_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 11, 11, 11
};

static const u8 rtw8812a_pwrtrk_2gb_p[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7
};

static const u8 rtw8812a_pwrtrk_2ga_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 8, 8, 9, 10, 10, 10, 10, 10, 10
};

static const u8 rtw8812a_pwrtrk_2ga_p[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7
};

static const u8 rtw8812a_pwrtrk_2g_cck_b_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 11, 11, 11
};

static const u8 rtw8812a_pwrtrk_2g_cck_b_p[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7
};

static const u8 rtw8812a_pwrtrk_2g_cck_a_n[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 8, 8, 9, 10, 10, 10, 10, 10, 10
};

static const u8 rtw8812a_pwrtrk_2g_cck_a_p[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7
};

const struct rtw_pwr_track_tbl rtw8812a_rtw_pwr_track_tbl = {
	.pwrtrk_5gb_n[0] = rtw8812a_pwrtrk_5gb_n[0],
	.pwrtrk_5gb_n[1] = rtw8812a_pwrtrk_5gb_n[1],
	.pwrtrk_5gb_n[2] = rtw8812a_pwrtrk_5gb_n[2],
	.pwrtrk_5gb_p[0] = rtw8812a_pwrtrk_5gb_p[0],
	.pwrtrk_5gb_p[1] = rtw8812a_pwrtrk_5gb_p[1],
	.pwrtrk_5gb_p[2] = rtw8812a_pwrtrk_5gb_p[2],
	.pwrtrk_5ga_n[0] = rtw8812a_pwrtrk_5ga_n[0],
	.pwrtrk_5ga_n[1] = rtw8812a_pwrtrk_5ga_n[1],
	.pwrtrk_5ga_n[2] = rtw8812a_pwrtrk_5ga_n[2],
	.pwrtrk_5ga_p[0] = rtw8812a_pwrtrk_5ga_p[0],
	.pwrtrk_5ga_p[1] = rtw8812a_pwrtrk_5ga_p[1],
	.pwrtrk_5ga_p[2] = rtw8812a_pwrtrk_5ga_p[2],
	.pwrtrk_2gb_n = rtw8812a_pwrtrk_2gb_n,
	.pwrtrk_2gb_p = rtw8812a_pwrtrk_2gb_p,
	.pwrtrk_2ga_n = rtw8812a_pwrtrk_2ga_n,
	.pwrtrk_2ga_p = rtw8812a_pwrtrk_2ga_p,
	.pwrtrk_2g_cckb_n = rtw8812a_pwrtrk_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8812a_pwrtrk_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8812a_pwrtrk_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8812a_pwrtrk_2g_cck_a_p,
};

static const u8 rtw8812a_pwrtrk_rfe3_5gb_n[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 13,
	 13, 14, 15, 16, 16, 17, 17, 18, 18},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11,
	 12, 14, 13, 13, 14, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 13, 13, 14, 14, 15, 15, 16, 16},
};

static const u8 rtw8812a_pwrtrk_rfe3_5gb_p[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 10, 10, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
};

static const u8 rtw8812a_pwrtrk_rfe3_5ga_n[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12,
	 13, 14, 15, 16, 16, 17, 17, 18, 18},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 12,
	 12, 13, 13, 14, 15, 16, 16, 17, 17},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 12, 13,
	 13, 14, 14, 15, 15, 16, 17, 18, 18},
};

static const u8 rtw8812a_pwrtrk_rfe3_5ga_p[][RTW_PWR_TRK_TBL_SZ] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 11, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
	{0, 1, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 11, 11, 11, 11,
	 11, 11, 11, 11, 11, 11, 11, 11, 11},
};

static const u8 rtw8812a_pwrtrk_rfe3_2gb_n[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7,
	7, 7, 8, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 15
};

static const u8 rtw8812a_pwrtrk_rfe3_2gb_p[] = {
	0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6,
	6, 7, 7, 8, 9, 10, 10, 10, 10, 11, 11, 11, 11, 11
};

static const u8 rtw8812a_pwrtrk_rfe3_2ga_n[] = {
	0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9,
	10, 10, 11, 11, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15
};

static const u8 rtw8812a_pwrtrk_rfe3_2ga_p[] = {
	0, 0, 1, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 11, 11
};

static const u8 rtw8812a_pwrtrk_rfe3_2g_cck_b_n[] = {
	0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7,
	7, 7, 8, 8, 9, 9, 10, 11, 12, 12, 13, 14, 15, 15
};

static const u8 rtw8812a_pwrtrk_rfe3_2g_cck_b_p[] = {
	0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6,
	6, 7, 7, 8, 9, 10, 10, 10, 10, 11, 11, 11, 11, 11
};

static const u8 rtw8812a_pwrtrk_rfe3_2g_cck_a_n[] = {
	0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9,
	10, 10, 11, 11, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15
};

static const u8 rtw8812a_pwrtrk_rfe3_2g_cck_a_p[] = {
	0, 0, 1, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 6,
	6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 11, 11
};

const struct rtw_pwr_track_tbl rtw8812a_rtw_pwr_track_rfe3_tbl = {
	.pwrtrk_5gb_n[0] = rtw8812a_pwrtrk_rfe3_5gb_n[0],
	.pwrtrk_5gb_n[1] = rtw8812a_pwrtrk_rfe3_5gb_n[1],
	.pwrtrk_5gb_n[2] = rtw8812a_pwrtrk_rfe3_5gb_n[2],
	.pwrtrk_5gb_p[0] = rtw8812a_pwrtrk_rfe3_5gb_p[0],
	.pwrtrk_5gb_p[1] = rtw8812a_pwrtrk_rfe3_5gb_p[1],
	.pwrtrk_5gb_p[2] = rtw8812a_pwrtrk_rfe3_5gb_p[2],
	.pwrtrk_5ga_n[0] = rtw8812a_pwrtrk_rfe3_5ga_n[0],
	.pwrtrk_5ga_n[1] = rtw8812a_pwrtrk_rfe3_5ga_n[1],
	.pwrtrk_5ga_n[2] = rtw8812a_pwrtrk_rfe3_5ga_n[2],
	.pwrtrk_5ga_p[0] = rtw8812a_pwrtrk_rfe3_5ga_p[0],
	.pwrtrk_5ga_p[1] = rtw8812a_pwrtrk_rfe3_5ga_p[1],
	.pwrtrk_5ga_p[2] = rtw8812a_pwrtrk_rfe3_5ga_p[2],
	.pwrtrk_2gb_n = rtw8812a_pwrtrk_rfe3_2gb_n,
	.pwrtrk_2gb_p = rtw8812a_pwrtrk_rfe3_2gb_p,
	.pwrtrk_2ga_n = rtw8812a_pwrtrk_rfe3_2ga_n,
	.pwrtrk_2ga_p = rtw8812a_pwrtrk_rfe3_2ga_p,
	.pwrtrk_2g_cckb_n = rtw8812a_pwrtrk_rfe3_2g_cck_b_n,
	.pwrtrk_2g_cckb_p = rtw8812a_pwrtrk_rfe3_2g_cck_b_p,
	.pwrtrk_2g_ccka_n = rtw8812a_pwrtrk_rfe3_2g_cck_a_n,
	.pwrtrk_2g_ccka_p = rtw8812a_pwrtrk_rfe3_2g_cck_a_p,
};
